/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.std.date;

import io.rtron.std.date.ExperimentalDateTime;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/rtron/std/date/DateTime;", "", "_localDateTime", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;)V", "Companion", "rtron-std"})
@ExperimentalDateTime
public final class DateTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalDateTime _localDateTime;

    public DateTime(@NotNull LocalDateTime _localDateTime) {
        Intrinsics.checkNotNullParameter((Object)_localDateTime, (String)"_localDateTime");
        this._localDateTime = _localDateTime;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/rtron/std/date/DateTime$Companion;", "", "()V", "of", "Lio/rtron/std/date/DateTime;", "text", "Ljava/nio/file/attribute/FileTime;", "", "rtron-std"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTime of(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            LocalDateTime localDateTime = LocalDateTime.parse(text);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(text)");
            return new DateTime(localDateTime);
        }

        @NotNull
        public final DateTime of(@NotNull FileTime text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            LocalDateTime localDateTime = LocalDateTime.ofInstant(text.toInstant(), ZoneId.systemDefault());
            Intrinsics.checkNotNull((Object)localDateTime);
            LocalDateTime ldt = localDateTime;
            return new DateTime(ldt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

