/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.io.logging;

import com.github.kittinunf.result.Result;
import com.vdurmont.emoji.EmojiParser;
import io.rtron.std.ContextMessage;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J&\u0010\t\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007J\u001a\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J(\u0010\u0012\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007J,\u0010\u0016\u001a\u00020\u00102\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u00182\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J8\u0010\u0016\u001a\u00020\u00102\u001c\u0010\u001b\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001d\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u001c2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J(\u0010\u0016\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J&\u0010\u0016\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060\u0019j\u0002`\u001a2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001a\u0010!\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010!\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J(\u0010!\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/rtron/io/logging/Logger;", "", "logger", "Lmu/KLogger;", "(Lmu/KLogger;)V", "_infoOnceMessages", "", "", "_warnOnceMessages", "combineMessage", "message", "prefix", "suffix", "messages", "", "debug", "", "error", "info", "force", "", "infoOnce", "log", "failure", "Lcom/github/kittinunf/result/Result$Failure;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "result", "Lcom/github/kittinunf/result/Result;", "Lio/rtron/std/ContextMessage;", "contextMessage", "exception", "prepareMessage", "warn", "warnOnce", "rtron-io"})
public final class Logger {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Set<String> _infoOnceMessages;
    @NotNull
    private final Set<String> _warnOnceMessages;

    public Logger(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        boolean bl = false;
        this._infoOnceMessages = new LinkedHashSet();
        bl = false;
        this._warnOnceMessages = new LinkedHashSet();
    }

    public final void infoOnce(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this._infoOnceMessages.contains(message)) {
            this._infoOnceMessages.add(message);
            Logger.info$default(this, message, false, 2, null);
        }
    }

    public final void info(@NotNull String message, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Logger.info$default(this, this.combineMessage(message, prefix, suffix), false, 2, null);
    }

    public static /* synthetic */ void info$default(Logger logger, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        logger.info(string, string2, string3);
    }

    public final void info(@NotNull List<String> messages, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Logger.info$default(this, this.combineMessage(messages, prefix, suffix), false, 2, null);
    }

    public static /* synthetic */ void info$default(Logger logger, List list, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        logger.info(list, string, string2);
    }

    public final void warnOnce(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this._warnOnceMessages.contains(message)) {
            this._warnOnceMessages.add(message);
            Logger.warn$default(this, message, false, 2, null);
        }
    }

    public final void warn(@NotNull String message, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Logger.warn$default(this, this.combineMessage(message, prefix, suffix), false, 2, null);
    }

    public static /* synthetic */ void warn$default(Logger logger, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        logger.warn(string, string2, string3);
    }

    public final void warn(@NotNull List<String> messages, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Logger.warn$default(this, this.combineMessage(messages, prefix, suffix), false, 2, null);
    }

    public static /* synthetic */ void warn$default(Logger logger, List list, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        logger.warn(list, string, string2);
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.error(message);
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.debug(message);
    }

    public final void log(@NotNull Result.Failure<? extends Exception> failure, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter(failure, (String)"failure");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.log(failure.getException(), prefix, suffix);
    }

    public static /* synthetic */ void log$default(Logger logger, Result.Failure failure, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        logger.log((Result.Failure<? extends Exception>)failure, string, string2);
    }

    public final void log(@NotNull Exception exception, @NotNull String prefix, @NotNull String suffix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        CharSequence charSequence = exception.getMessage();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            string = exception.toString();
        } else {
            String string2 = exception.getMessage();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String warningMessage = string;
        this.warn(warningMessage, prefix, suffix);
    }

    public static /* synthetic */ void log$default(Logger logger, Exception exception, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        logger.log(exception, string, string2);
    }

    public final void log(@NotNull ContextMessage<? extends Object> contextMessage, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter(contextMessage, (String)"contextMessage");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.info(contextMessage.getMessages(), prefix, suffix);
    }

    public static /* synthetic */ void log$default(Logger logger, ContextMessage contextMessage, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        logger.log((ContextMessage<? extends Object>)contextMessage, string, string2);
    }

    public final void log(@NotNull Result<? extends ContextMessage<? extends Object>, ? extends Exception> result, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Result<? extends ContextMessage<? extends Object>, ? extends Exception> this_$iv = result;
        boolean $i$f$fold = false;
        Result<? extends ContextMessage<? extends Object>, ? extends Exception> result2 = this_$iv;
        if (result2 instanceof Result.Success) {
            ContextMessage it = (ContextMessage)((Result.Success)this_$iv).getValue();
            boolean bl = false;
            this.log((ContextMessage<? extends Object>)it, prefix, suffix);
        } else if (result2 instanceof Result.Failure) {
            Exception it = ((Result.Failure)this_$iv).getError();
            boolean bl = false;
            this.log(it, prefix, suffix);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void log$default(Logger logger, Result result, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        logger.log((Result<? extends ContextMessage<? extends Object>, ? extends Exception>)result, string, string2);
    }

    private final String combineMessage(List<String> messages, String prefix, String suffix) {
        return this.combineMessage(CollectionsKt.joinToString$default((Iterable)messages, null, null, null, (int)0, null, null, (int)63, null), prefix, suffix);
    }

    private final String combineMessage(String message, String prefix, String suffix) {
        CharSequence charSequence = message;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        CharSequence charSequence2 = prefix;
        boolean bl2 = false;
        String prefixedMessage = charSequence2.length() == 0 ? message : prefix + ": " + message;
        charSequence2 = suffix;
        bl2 = false;
        return charSequence2.length() == 0 ? prefixedMessage : prefixedMessage + ' ' + suffix;
    }

    private final void info(String message, boolean force) {
        CharSequence charSequence = message;
        boolean bl = false;
        if (charSequence.length() > 0 || force) {
            this.logger.info(this.prepareMessage(message));
        }
    }

    static /* synthetic */ void info$default(Logger logger, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        logger.info(string, bl);
    }

    private final String prepareMessage(String message) {
        String string;
        if (SystemUtils.IS_OS_WINDOWS) {
            String string2 = EmojiParser.removeAllEmojis((String)message);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"removeAllEmojis(message)");
            boolean bl = false;
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = message;
        }
        return string;
    }

    private final void warn(String message, boolean force) {
        CharSequence charSequence = message;
        boolean bl = false;
        if (charSequence.length() > 0 || force) {
            this.logger.warn(message);
        }
    }

    static /* synthetic */ void warn$default(Logger logger, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        logger.warn(string, bl);
    }
}

