/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.io.files;

import io.rtron.io.files.File;
import io.rtron.io.files.Path;
import io.rtron.io.files.PathKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0003J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000%2\u0006\u0010&\u001a\u00020\u0000J\b\u0010'\u001a\u00020\u0017H\u0016J\u0011\u0010(\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0004J\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u001eJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0006J\b\u00102\u001a\u00020\u0003H\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0000052\b\b\u0002\u00106\u001a\u00020\u0017J\u0006\u00107\u001a\u00020\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0011\u0010\u000eR\u001b\u0010\u0013\u001a\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0014\u0010\u000e\u00a8\u00068"}, d2={"Lio/rtron/io/files/Path;", "", "uri", "", "(Ljava/lang/String;)V", "_path", "Ljava/nio/file/Path;", "extension", "getExtension", "()Ljava/lang/String;", "extension$delegate", "Lkotlin/Lazy;", "fileName", "getFileName", "()Lio/rtron/io/files/Path;", "fileName$delegate", "fileNameWithoutExtension", "getFileNameWithoutExtension", "fileNameWithoutExtension$delegate", "parent", "getParent", "parent$delegate", "compareTo", "", "other", "createDirectory", "", "deleteDirectory", "deleteDirectoryContents", "equals", "", "", "exists", "getFileSize", "", "getFileSizeToDisplay", "getParents", "", "baseParent", "hashCode", "isChildOf", "isDirectory", "isRegularFile", "relativize", "resolve", "toFile", "Lio/rtron/io/files/File;", "toFileJ", "Ljava/io/File;", "toPathN", "toString", "updateFileName", "walk", "Lkotlin/sequences/Sequence;", "maxDepth", "withoutExtension", "rtron-io"})
public final class Path
implements Comparable<Path> {
    @NotNull
    private final java.nio.file.Path _path;
    @NotNull
    private final Lazy fileName$delegate;
    @NotNull
    private final Lazy fileNameWithoutExtension$delegate;
    @NotNull
    private final Lazy parent$delegate;
    @NotNull
    private final Lazy extension$delegate;

    public Path(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        java.nio.file.Path path = Paths.get(uri, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(uri)");
        this._path = path;
        this.fileName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ Path this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                java.nio.file.Path path = Path.access$get_path$p(this.this$0).getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"_path.fileName");
                return PathKt.toPath(path);
            }
        }));
        this.fileNameWithoutExtension$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ Path this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                return this.this$0.withoutExtension().getFileName();
            }
        }));
        this.parent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ Path this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                java.nio.file.Path path = Path.access$get_path$p(this.this$0).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"_path.parent");
                return PathKt.toPath(path);
            }
        }));
        this.extension$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Path this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return FilenameUtils.getExtension((String)this.this$0.toString());
            }
        }));
    }

    public /* synthetic */ Path(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final Path getFileName() {
        Lazy lazy = this.fileName$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final Path getFileNameWithoutExtension() {
        Lazy lazy = this.fileNameWithoutExtension$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final Path getParent() {
        Lazy lazy = this.parent$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final String getExtension() {
        Lazy lazy = this.extension$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-extension>(...)");
        return (String)object;
    }

    public final boolean exists() {
        return Files.exists(this._path, new LinkOption[0]);
    }

    public final boolean isRegularFile() {
        return Files.isRegularFile(this._path, new LinkOption[0]);
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this._path, new LinkOption[0]);
    }

    @NotNull
    public final Sequence<Path> walk(int maxDepth) {
        Stream<java.nio.file.Path> stream = Files.walk(this._path, maxDepth, new FileVisitOption[0]);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(_path, maxDepth)");
        return SequencesKt.map((Sequence)StreamsKt.asSequence(stream), (Function1)walk.1.INSTANCE);
    }

    public static /* synthetic */ Sequence walk$default(Path path, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return path.walk(n);
    }

    @NotNull
    public final Path resolve(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.nio.file.Path path = this._path.resolve(other.toPathN());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"_path.resolve(other.toPathN())");
        return PathKt.toPath(path);
    }

    @NotNull
    public final Path withoutExtension() {
        String string = FilenameUtils.removeExtension((String)this.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeExtension(this.toString())");
        return new Path(string);
    }

    @NotNull
    public final Path relativize(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.nio.file.Path path = this._path.relativize(other.toPathN());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"_path.relativize(other.toPathN())");
        return PathKt.toPath(path);
    }

    @NotNull
    public final Path updateFileName(@NotNull String fileName2) {
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        return this.getParent().resolve(new Path(fileName2));
    }

    public final void createDirectory() {
        Files.createDirectories(this._path, new FileAttribute[0]);
    }

    public final void deleteDirectory() {
        FileUtils.deleteDirectory((java.io.File)this.toFileJ());
    }

    public final void deleteDirectoryContents() {
        if (this.exists()) {
            FileUtils.cleanDirectory((java.io.File)this.toFileJ());
        }
    }

    public final boolean isChildOf(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toPathN().startsWith(other.toPathN());
    }

    @NotNull
    public final List<Path> getParents(@NotNull Path baseParent) {
        Intrinsics.checkNotNullParameter((Object)baseParent, (String)"baseParent");
        boolean bl = this.isChildOf(baseParent);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Base path must be a parent path.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)this.getParent(), (Function1)getParents.2.INSTANCE), (Function1)((Function1)new Function1<Path, Boolean>(baseParent){
            final /* synthetic */ Path $baseParent;
            {
                this.$baseParent = $baseParent;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isChildOf(this.$baseParent);
            }
        })));
    }

    public final long getFileSize() {
        return FileUtils.sizeOf((java.io.File)this.toFileJ());
    }

    @NotNull
    public final String getFileSizeToDisplay() {
        String string = FileUtils.byteCountToDisplaySize((long)this.getFileSize());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"byteCountToDisplaySize(getFileSize())");
        return string;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this._path.compareTo(other._path);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Path)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this._path, (Object)((Path)other)._path);
    }

    public int hashCode() {
        return ((Object)this._path).hashCode();
    }

    @NotNull
    public final java.nio.file.Path toPathN() {
        return this._path;
    }

    @NotNull
    public String toString() {
        return ((Object)this._path).toString();
    }

    @NotNull
    public final java.io.File toFileJ() {
        java.io.File file = this._path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"_path.toFile()");
        return file;
    }

    @NotNull
    public final File toFile() {
        return new File(this);
    }

    public Path() {
        this(null, 1, null);
    }

    public static final /* synthetic */ java.nio.file.Path access$get_path$p(Path $this) {
        return $this._path;
    }
}

