/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.io.logging;

import io.rtron.io.logging.LogManager;
import io.rtron.io.logging.Logger;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0010J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0010J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lio/rtron/io/logging/ProgressBar;", "", "taskName", "", "completion", "", "currentStatus", "(Ljava/lang/String;II)V", "lastPrintUpdateTime", "", "logger", "Lio/rtron/io/logging/Logger;", "startTime", "getElapsedTime", "Lkotlin/time/Duration;", "getElapsedTime-UwyO8pc", "()J", "getElapsedTimeSinceLastUpdate", "getElapsedTimeSinceLastUpdate-UwyO8pc", "getEstimatedTimeOfArrival", "getEstimatedTimeOfArrival-UwyO8pc", "getProgressPercent", "", "getTotalEstimatedElapsedTime", "getTotalEstimatedElapsedTime-UwyO8pc", "isCompleted", "", "printUpdate", "", "step", "stepTo", "n", "Companion", "rtron-io"})
public final class ProgressBar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String taskName;
    private final int completion;
    private int currentStatus;
    @NotNull
    private final Logger logger;
    private final long startTime;
    private long lastPrintUpdateTime;
    private static final long PRINT_AFTER = DurationKt.toDuration((int)10, (TimeUnit)TimeUnit.SECONDS);
    private static final long PRINT_AT_LEAST = DurationKt.toDuration((int)10, (TimeUnit)TimeUnit.SECONDS);

    public ProgressBar(@NotNull String taskName, int completion, int currentStatus) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        this.taskName = taskName;
        this.completion = completion;
        this.currentStatus = currentStatus;
        this.logger = LogManager.INSTANCE.getReportLogger("Progress");
        this.startTime = System.currentTimeMillis();
    }

    public /* synthetic */ ProgressBar(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(string, n, n2);
    }

    public final void step() {
        ProgressBar progressBar = this;
        ++progressBar.currentStatus;
        this.printUpdate();
    }

    public final void stepTo(int n) {
        this.currentStatus = n;
        this.printUpdate();
    }

    public final boolean isCompleted() {
        return this.currentStatus >= this.completion;
    }

    private final void printUpdate() {
        long elapsedTime = this.getElapsedTime-UwyO8pc();
        if (Duration.compareTo-LRDsOJo((long)elapsedTime, (long)PRINT_AFTER) > 0 && (Duration.compareTo-LRDsOJo((long)this.getElapsedTimeSinceLastUpdate-UwyO8pc(), (long)PRINT_AT_LEAST) > 0 || this.isCompleted())) {
            Logger.info$default(this.logger, this.taskName + ' ' + this.currentStatus + '/' + this.completion + ' ' + MathKt.roundToInt((double)this.getProgressPercent()) + "% [ET " + Duration.toString-impl((long)elapsedTime) + ", ETA " + Duration.toString-impl((long)this.getEstimatedTimeOfArrival-UwyO8pc()) + ']', null, null, 6, null);
            this.lastPrintUpdateTime = System.currentTimeMillis();
        }
    }

    private final long getElapsedTimeSinceLastUpdate-UwyO8pc() {
        return DurationKt.toDuration((long)(System.currentTimeMillis() - this.lastPrintUpdateTime), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final double getProgressPercent() {
        return 100.0 * ((double)this.currentStatus / (double)this.completion);
    }

    private final long getElapsedTime-UwyO8pc() {
        return DurationKt.toDuration((long)(System.currentTimeMillis() - this.startTime), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final long getTotalEstimatedElapsedTime-UwyO8pc() {
        return Duration.div-UwyO8pc((long)Duration.times-UwyO8pc((long)this.getElapsedTime-UwyO8pc(), (double)this.completion), (double)this.currentStatus);
    }

    private final long getEstimatedTimeOfArrival-UwyO8pc() {
        return Duration.times-UwyO8pc((long)this.getElapsedTime-UwyO8pc(), (double)((double)this.completion / (double)this.currentStatus - 1.0));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\n"}, d2={"Lio/rtron/io/logging/ProgressBar$Companion;", "", "()V", "PRINT_AFTER", "Lkotlin/time/Duration;", "getPRINT_AFTER-UwyO8pc", "()J", "J", "PRINT_AT_LEAST", "getPRINT_AT_LEAST-UwyO8pc", "rtron-io"})
    public static final class Companion {
        private Companion() {
        }

        public final long getPRINT_AFTER-UwyO8pc() {
            return PRINT_AFTER;
        }

        public final long getPRINT_AT_LEAST-UwyO8pc() {
            return PRINT_AT_LEAST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

