/*
 * Decompiled with CFR 0.152.
 */
package io.slink.string;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u00020\u000e*\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\u000e*\u00020\u000e\u001a\n\u0010\u0013\u001a\u00020\u000e*\u00020\u000e\u001a\n\u0010\u0014\u001a\u00020\u000e*\u00020\u000e\u001a\n\u0010\u0015\u001a\u00020\u000e*\u00020\u000e\u001a\u0012\u0010\u0016\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010\u001a \u0010\u0018\u001a\u00020\u000e\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a*\b\u0012\u0004\u0012\u0002H\u00190\u001a\u001a\n\u0010\u0018\u001a\u00020\u000e*\u00020\u000e\u001a\n\u0010\u001b\u001a\u00020\u000e*\u00020\u000e\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000e\u001a\n\u0010\u001d\u001a\u00020\u000e*\u00020\u000e\u001a\u0014\u0010\u001e\u001a\u00020\u000e*\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020 \u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"*\u00020\u000e\u001a\u0014\u0010#\u001a\u00020\u000e*\u00020\u000e2\b\b\u0002\u0010$\u001a\u00020%\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0011\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006&"}, d2={"DOMAIN_COLON_SLASHES", "Lkotlin/text/Regex;", "DOMAIN_PORT", "DOMAIN_REST_OF_PATH", "PATTERN_KEBAB", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REGEX_CAMEL", "REGEX_NON_ALPHA", "getREGEX_NON_ALPHA", "()Lkotlin/text/Regex;", "REGEX_WHITESPACE", "getREGEX_WHITESPACE", "anonymize", "", "visibleEndChars", "", "anonymizeEmail", "camelToKebabCase", "cleanEmail", "cleanWhitespace", "domain", "ellipsis", "maxLength", "enumLabel", "E", "", "kebabToCamelCase", "nullIfBlank", "removeWhitespace", "titleCaseFirstChar", "locale", "Ljava/util/Locale;", "toLines", "", "urlEncode", "charset", "Ljava/nio/charset/Charset;", "slink-zero"})
@SourceDebugExtension(value={"SMAP\nstrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 strings.kt\nio/slink/string/StringsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n11505#3:103\n11640#3,4:104\n1549#4:108\n1620#4,3:109\n766#4:112\n857#4,2:113\n*S KotlinDebug\n*F\n+ 1 strings.kt\nio/slink/string/StringsKt\n*L\n57#1:103\n57#1:104,4\n77#1:108\n77#1:109,3\n78#1:112\n78#1:113,2\n*E\n"})
public final class StringsKt {
    @NotNull
    private static final Regex REGEX_NON_ALPHA = new Regex("[^a-zA-Z\\d]+");
    @NotNull
    private static final Regex REGEX_WHITESPACE = new Regex("\\s+");
    @NotNull
    private static final Regex DOMAIN_COLON_SLASHES = new Regex(".*://");
    @NotNull
    private static final Regex DOMAIN_PORT = new Regex(":.*");
    @NotNull
    private static final Regex DOMAIN_REST_OF_PATH = new Regex("/.*");
    private static final Pattern PATTERN_KEBAB = Pattern.compile("-([a-z])");
    @NotNull
    private static final Regex REGEX_CAMEL = new Regex("([a-z0-9])([A-Z])");

    @NotNull
    public static final Regex getREGEX_NON_ALPHA() {
        return REGEX_NON_ALPHA;
    }

    @NotNull
    public static final Regex getREGEX_WHITESPACE() {
        return REGEX_WHITESPACE;
    }

    @NotNull
    public static final String urlEncode(@NotNull String $this$urlEncode, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$urlEncode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String string = URLEncoder.encode($this$urlEncode, charset.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(this, charset.name())");
        return string;
    }

    public static /* synthetic */ String urlEncode$default(String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return StringsKt.urlEncode(string, charset);
    }

    @NotNull
    public static final String cleanWhitespace(@NotNull String $this$cleanWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanWhitespace, (String)"<this>");
        CharSequence charSequence = $this$cleanWhitespace;
        Regex regex = REGEX_WHITESPACE;
        String string = " ";
        return ((Object)kotlin.text.StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    @NotNull
    public static final String removeWhitespace(@NotNull String $this$removeWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$removeWhitespace, (String)"<this>");
        CharSequence charSequence = $this$removeWhitespace;
        Regex regex = REGEX_WHITESPACE;
        String string = "";
        return ((Object)kotlin.text.StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String titleCaseFirstChar(@NotNull String $this$titleCaseFirstChar, @NotNull Locale locale) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$titleCaseFirstChar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string2 = $this$titleCaseFirstChar;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)it, (Locale)locale));
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        return string;
    }

    public static /* synthetic */ String titleCaseFirstChar$default(String string, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return StringsKt.titleCaseFirstChar(string, locale);
    }

    @NotNull
    public static final String cleanEmail(@NotNull String $this$cleanEmail) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanEmail, (String)"<this>");
        String string = StringsKt.cleanWhitespace($this$cleanEmail).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    @NotNull
    public static final String ellipsis(@NotNull String $this$ellipsis, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsis, (String)"<this>");
        return $this$ellipsis.length() > maxLength ? kotlin.text.StringsKt.take((String)$this$ellipsis, (int)(maxLength - 3)) + "..." : $this$ellipsis;
    }

    @Nullable
    public static final String nullIfBlank(@Nullable String $this$nullIfBlank) {
        return $this$nullIfBlank != null && kotlin.text.StringsKt.isBlank((CharSequence)$this$nullIfBlank) ? null : $this$nullIfBlank;
    }

    @NotNull
    public static final String anonymizeEmail(@NotNull String $this$anonymizeEmail, int visibleEndChars) {
        Intrinsics.checkNotNullParameter((Object)$this$anonymizeEmail, (String)"<this>");
        String[] stringArray = new String[]{"@"};
        List elements = kotlin.text.StringsKt.split$default((CharSequence)$this$anonymizeEmail, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return StringsKt.anonymize((String)elements.get(0), visibleEndChars) + "@" + StringsKt.anonymize((String)elements.get(1), visibleEndChars);
    }

    public static /* synthetic */ String anonymizeEmail$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return StringsKt.anonymizeEmail(string, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String anonymize(@NotNull String $this$anonymize, int visibleEndChars) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$anonymize, (String)"<this>");
        int visibleStartIndex = RangesKt.coerceAtLeast((int)($this$anonymize.length() - visibleEndChars), (int)0);
        char[] cArray = $this$anonymize.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] $this$mapIndexed$iv = cArray;
        boolean $i$f$mapIndexed = false;
        char[] cArray2 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void char_;
            void index;
            int n = index$iv$iv++;
            void var12_12 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(index < visibleStartIndex ? (char)'*' : char_));
        }
        char[] cArray3 = CollectionsKt.toCharArray((Collection)((List)destination$iv$iv));
        return new String(cArray3);
    }

    public static /* synthetic */ String anonymize$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return StringsKt.anonymize(string, n);
    }

    @NotNull
    public static final String domain(@NotNull String $this$domain) {
        Intrinsics.checkNotNullParameter((Object)$this$domain, (String)"<this>");
        String string = $this$domain.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        CharSequence charSequence = string;
        Regex regex = DOMAIN_COLON_SLASHES;
        String string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = DOMAIN_PORT;
        string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = DOMAIN_REST_OF_PATH;
        string2 = "";
        return regex.replace(charSequence, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> toLines(@NotNull String $this$toLines) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toLines, (String)"<this>");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = kotlin.text.StringsKt.split$default((CharSequence)$this$toLines, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)kotlin.text.StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <E extends Enum<E>> String enumLabel(@NotNull Enum<E> $this$enumLabel) {
        Intrinsics.checkNotNullParameter($this$enumLabel, (String)"<this>");
        return StringsKt.enumLabel($this$enumLabel.name());
    }

    @NotNull
    public static final String enumLabel(@NotNull String $this$enumLabel) {
        Intrinsics.checkNotNullParameter((Object)$this$enumLabel, (String)"<this>");
        String string = kotlin.text.StringsKt.replace$default((String)$this$enumLabel, (String)"_", (String)" ", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.titleCaseFirstChar$default(string, null, 1, null);
    }

    @NotNull
    public static final String camelToKebabCase(@NotNull String $this$camelToKebabCase) {
        Intrinsics.checkNotNullParameter((Object)$this$camelToKebabCase, (String)"<this>");
        CharSequence charSequence = $this$camelToKebabCase;
        Regex regex = REGEX_CAMEL;
        String string = "$1-$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string2;
    }

    @NotNull
    public static final String kebabToCamelCase(@NotNull String $this$kebabToCamelCase) {
        Intrinsics.checkNotNullParameter((Object)$this$kebabToCamelCase, (String)"<this>");
        String string = PATTERN_KEBAB.matcher($this$kebabToCamelCase).replaceAll(StringsKt::kebabToCamelCase$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PATTERN_KEBAB\n          \u2026mr.group(1).uppercase() }");
        return string;
    }

    private static final String kebabToCamelCase$lambda$4(MatchResult mr) {
        String string = mr.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mr.group(1)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string2;
    }
}

