/*
 * Decompiled with CFR 0.152.
 */
package io.slink.iso3166;

import io.slink.resources.ResourcesKt;
import io.slink.tsv.TsvKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lio/slink/iso3166/Country;", "", "alpha2Code", "", "alpha3Code", "name", "otherNames", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAlpha2Code", "()Ljava/lang/String;", "getAlpha3Code", "getName", "getOtherNames", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "slink-zero"})
@SourceDebugExtension(value={"SMAP\nCountry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Country.kt\nio/slink/iso3166/Country\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1549#2:38\n1620#2,2:39\n1549#2:41\n1620#2,3:42\n1622#2:45\n1194#2,2:46\n1222#2,4:48\n1194#2,2:52\n1222#2,4:54\n*S KotlinDebug\n*F\n+ 1 Country.kt\nio/slink/iso3166/Country\n*L\n17#1:38\n17#1:39,2\n20#1:41\n20#1:42,3\n17#1:45\n30#1:46,2\n30#1:48,4\n31#1:52,2\n31#1:54,4\n*E\n"})
public final class Country {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String alpha2Code;
    @NotNull
    private final String alpha3Code;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> otherNames;
    @NotNull
    private static final List<Country> allCountries;
    @NotNull
    private static final Map<String, Country> countriesByCode;

    public Country(@NotNull String alpha2Code, @NotNull String alpha3Code, @NotNull String name, @NotNull List<String> otherNames) {
        Intrinsics.checkNotNullParameter((Object)alpha2Code, (String)"alpha2Code");
        Intrinsics.checkNotNullParameter((Object)alpha3Code, (String)"alpha3Code");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(otherNames, (String)"otherNames");
        this.alpha2Code = alpha2Code;
        this.alpha3Code = alpha3Code;
        this.name = name;
        this.otherNames = otherNames;
    }

    @NotNull
    public final String getAlpha2Code() {
        return this.alpha2Code;
    }

    @NotNull
    public final String getAlpha3Code() {
        return this.alpha3Code;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getOtherNames() {
        return this.otherNames;
    }

    @NotNull
    public final String component1() {
        return this.alpha2Code;
    }

    @NotNull
    public final String component2() {
        return this.alpha3Code;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final List<String> component4() {
        return this.otherNames;
    }

    @NotNull
    public final Country copy(@NotNull String alpha2Code, @NotNull String alpha3Code, @NotNull String name, @NotNull List<String> otherNames) {
        Intrinsics.checkNotNullParameter((Object)alpha2Code, (String)"alpha2Code");
        Intrinsics.checkNotNullParameter((Object)alpha3Code, (String)"alpha3Code");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(otherNames, (String)"otherNames");
        return new Country(alpha2Code, alpha3Code, name, otherNames);
    }

    public static /* synthetic */ Country copy$default(Country country, String string, String string2, String string3, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = country.alpha2Code;
        }
        if ((n & 2) != 0) {
            string2 = country.alpha3Code;
        }
        if ((n & 4) != 0) {
            string3 = country.name;
        }
        if ((n & 8) != 0) {
            list = country.otherNames;
        }
        return country.copy(string, string2, string3, list);
    }

    @NotNull
    public String toString() {
        return "Country(alpha2Code=" + this.alpha2Code + ", alpha3Code=" + this.alpha3Code + ", name=" + this.name + ", otherNames=" + this.otherNames + ")";
    }

    public int hashCode() {
        int result = this.alpha2Code.hashCode();
        result = result * 31 + this.alpha3Code.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + ((Object)this.otherNames).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Country)) {
            return false;
        }
        Country country = (Country)other;
        if (!Intrinsics.areEqual((Object)this.alpha2Code, (Object)country.alpha2Code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alpha3Code, (Object)country.alpha3Code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)country.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.otherNames, country.otherNames);
    }

    /*
     * WARNING - void declaration
     */
    static {
        Iterable $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = TsvKt.readTsvWithHeader$default(ResourcesKt.resourceAsString$default("slink/iso3166/iso3166-countries.tsv", null, 2, null), '\u0000', 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void row;
            Map map = (Map)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Object v = row.get("Alpha2Code");
            Intrinsics.checkNotNull(v);
            String alpha2Code = (String)v;
            Object v2 = row.get("Alpha3Code");
            Intrinsics.checkNotNull(v2);
            String alpha3Code = (String)v2;
            Object v3 = row.get("Names");
            Intrinsics.checkNotNull(v3);
            String[] stringArray = new String[]{";"};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)v3), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(io.slink.string.StringsKt.cleanWhitespace((String)it));
            }
            List names = (List)destination$iv$iv2;
            object.add(new Country(alpha2Code, alpha3Code, (String)CollectionsKt.first((List)names), names.size() > 1 ? names.subList(1, names.size()) : CollectionsKt.emptyList()));
        }
        allCountries = (List)destination$iv$iv;
        Iterable $this$associateBy$iv = allCountries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Country bl = (Country)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            String string = it.alpha2Code.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            object.put(string, element$iv$iv);
        }
        $this$associateBy$iv = allCountries;
        object = destination$iv$iv3;
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Country it = (Country)element$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            String string = it.alpha3Code.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            map.put(string, element$iv$iv);
        }
        countriesByCode = MapsKt.plus((Map)object, (Map)destination$iv$iv3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/slink/iso3166/Country$Companion;", "", "()V", "allCountries", "", "Lio/slink/iso3166/Country;", "getAllCountries", "()Ljava/util/List;", "countriesByCode", "", "", "byCode", "alpha2Or3Code", "slink-zero"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Country> getAllCountries() {
            return allCountries;
        }

        @NotNull
        public final Country byCode(@NotNull String alpha2Or3Code) {
            Intrinsics.checkNotNullParameter((Object)alpha2Or3Code, (String)"alpha2Or3Code");
            Map map = countriesByCode;
            String string = alpha2Or3Code.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            Object v = map.get(string);
            Intrinsics.checkNotNull(v);
            return (Country)v;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

