/*
 * Decompiled with CFR 0.152.
 */
package io.slink.datetime;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013*\u00020\u0015\u001a\u0012\u0010\u0016\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013*\u00020\u0015\u001a\u0012\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013*\u00020\u0015\u001a\u0012\u0010\u0018\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013*\u00020\u0015\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0013\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0001\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0013\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0013\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0003\"\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0003\u00a8\u0006 "}, d2={"dmyDash", "Ljava/time/format/DateTimeFormatter;", "getDmyDash", "()Ljava/time/format/DateTimeFormatter;", "dmyDashLoose", "getDmyDashLoose", "dmySlash", "getDmySlash", "dmySlashLoose", "getDmySlashLoose", "ymdDash", "getYmdDash", "ymdDashLoose", "getYmdDashLoose", "ymdSlash", "getYmdSlash", "ymdSlashLoose", "getYmdSlashLoose", "formatDmyDash", "", "kotlin.jvm.PlatformType", "Ljava/time/temporal/TemporalAccessor;", "formatDmySlash", "formatYmdDash", "formatYmdSlash", "localDate", "Ljava/time/LocalDate;", "dateStr", "format", "toDateFormat", "validDate", "", "slink-zero"})
public final class Datetime_formatsKt {
    @NotNull
    private static final DateTimeFormatter dmyDash = Datetime_formatsKt.toDateFormat("dd-MM-uuuu");
    @NotNull
    private static final DateTimeFormatter dmyDashLoose = Datetime_formatsKt.toDateFormat("d-M-uuuu");
    @NotNull
    private static final DateTimeFormatter dmySlash = Datetime_formatsKt.toDateFormat("dd/MM/uuuu");
    @NotNull
    private static final DateTimeFormatter dmySlashLoose = Datetime_formatsKt.toDateFormat("d/M/uuuu");
    @NotNull
    private static final DateTimeFormatter ymdDash = Datetime_formatsKt.toDateFormat("uuuu-MM-dd");
    @NotNull
    private static final DateTimeFormatter ymdDashLoose = Datetime_formatsKt.toDateFormat("uuuu-M-d");
    @NotNull
    private static final DateTimeFormatter ymdSlash = Datetime_formatsKt.toDateFormat("uuuu/MM/dd");
    @NotNull
    private static final DateTimeFormatter ymdSlashLoose = Datetime_formatsKt.toDateFormat("uuuu/M/d");

    @NotNull
    public static final DateTimeFormatter toDateFormat(@NotNull String $this$toDateFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateFormat, (String)"<this>");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern($this$toDateFormat).withResolverStyle(ResolverStyle.STRICT);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(this).withReso\u2026yle(ResolverStyle.STRICT)");
        return dateTimeFormatter;
    }

    @NotNull
    public static final DateTimeFormatter getDmyDash() {
        return dmyDash;
    }

    @NotNull
    public static final DateTimeFormatter getDmyDashLoose() {
        return dmyDashLoose;
    }

    @NotNull
    public static final DateTimeFormatter getDmySlash() {
        return dmySlash;
    }

    @NotNull
    public static final DateTimeFormatter getDmySlashLoose() {
        return dmySlashLoose;
    }

    @NotNull
    public static final DateTimeFormatter getYmdDash() {
        return ymdDash;
    }

    @NotNull
    public static final DateTimeFormatter getYmdDashLoose() {
        return ymdDashLoose;
    }

    @NotNull
    public static final DateTimeFormatter getYmdSlash() {
        return ymdSlash;
    }

    @NotNull
    public static final DateTimeFormatter getYmdSlashLoose() {
        return ymdSlashLoose;
    }

    @NotNull
    public static final LocalDate localDate(@NotNull DateTimeFormatter $this$localDate, @NotNull String dateStr) {
        Intrinsics.checkNotNullParameter((Object)$this$localDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateStr, (String)"dateStr");
        LocalDate localDate = LocalDate.from($this$localDate.parse(dateStr));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"from(this.parse(dateStr))");
        return localDate;
    }

    public static final boolean validDate(@NotNull DateTimeFormatter $this$validDate, @NotNull String dateStr) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$validDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateStr, (String)"dateStr");
        try {
            $this$validDate.parse(dateStr);
            bl = true;
        }
        catch (DateTimeParseException e) {
            bl = false;
        }
        return bl;
    }

    public static final String formatYmdDash(@NotNull TemporalAccessor $this$formatYmdDash) {
        Intrinsics.checkNotNullParameter((Object)$this$formatYmdDash, (String)"<this>");
        return ymdDash.format($this$formatYmdDash);
    }

    public static final String formatYmdSlash(@NotNull TemporalAccessor $this$formatYmdSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$formatYmdSlash, (String)"<this>");
        return ymdSlash.format($this$formatYmdSlash);
    }

    public static final String formatDmyDash(@NotNull TemporalAccessor $this$formatDmyDash) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDmyDash, (String)"<this>");
        return dmyDash.format($this$formatDmyDash);
    }

    public static final String formatDmySlash(@NotNull TemporalAccessor $this$formatDmySlash) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDmySlash, (String)"<this>");
        return dmySlash.format($this$formatDmySlash);
    }

    @NotNull
    public static final LocalDate localDate(@NotNull String $this$localDate, @NotNull DateTimeFormatter format) {
        Intrinsics.checkNotNullParameter((Object)$this$localDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return Datetime_formatsKt.localDate(format, $this$localDate);
    }
}

