/*
 * Decompiled with CFR 0.152.
 */
package io.slink.currency;

import io.slink.currency.Currencies;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"fractionalAmountToString", "", "Ljava/util/Currency;", "decimalAmount", "", "slink-zero"})
public final class CurrenciesKt {
    @NotNull
    public static final String fractionalAmountToString(@NotNull Currency $this$fractionalAmountToString, long decimalAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$fractionalAmountToString, (String)"<this>");
        BigDecimal value = new BigDecimal(decimalAmount).divide(new BigDecimal(Math.pow(10.0, $this$fractionalAmountToString.getDefaultFractionDigits())));
        String decimals = $this$fractionalAmountToString.getDefaultFractionDigits() > 0 ? StringsKt.padEnd((String)".", (int)($this$fractionalAmountToString.getDefaultFractionDigits() + 1), (char)'0') : "";
        String string = $this$fractionalAmountToString.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.currencyCode");
        String symbol = Currencies.INSTANCE.getSymbol(string);
        return decimalAmount >= 0L ? symbol + new DecimalFormat("#,##0" + decimals).format(value) : "-" + symbol + new DecimalFormat("#,###" + decimals).format(value.abs());
    }
}

