/*
 * Decompiled with CFR 0.152.
 */
package io.slink.http;

import io.slink.http.ResponseKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lio/slink/http/SlinkHttpException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "url", "", "code", "", "responseBody", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()I", "getResponseBody", "()Ljava/lang/String;", "getUrl", "slink-http"})
public final class SlinkHttpException
extends RuntimeException {
    @NotNull
    private final String url;
    private final int code;
    @NotNull
    private final String responseBody;

    public SlinkHttpException(@NotNull String url, int code, @NotNull String responseBody) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        super("Error on HTTP request " + url + ". Status code is " + code + " and response body is " + responseBody);
        this.url = url;
        this.code = code;
        this.responseBody = responseBody;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getResponseBody() {
        return this.responseBody;
    }

    public SlinkHttpException(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this(response.request().url().toString(), response.code(), ResponseKt.text(response));
    }
}

