/*
 * Decompiled with CFR 0.152.
 */
package io.slink.http;

import io.slink.http.SlinkHttpException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u0004*\u00020\u00042\n\u0010\u0006\u001a\u00020\u0007\"\u00020\u0001\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0004\u001a/\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r*\u00020\u00042\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014\u001a\u0012\u0010\u0013\u001a\u00020\u0016*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"HTTP_CREATED", "", "HTTP_OK", "checkOk", "Lokhttp3/Response;", "checkStatus", "successCodes", "", "isOk", "", "text", "", "withBody", "T", "handler", "Lkotlin/Function2;", "", "Ljava/io/InputStream;", "(Lokhttp3/Response;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "writeTo", "Ljava/io/File;", "file", "", "outputStream", "Ljava/io/OutputStream;", "slink-http"})
public final class ResponseKt {
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;

    public static final boolean isOk(@NotNull Response $this$isOk) {
        Intrinsics.checkNotNullParameter((Object)$this$isOk, (String)"<this>");
        return $this$isOk.code() == 200 || $this$isOk.code() == 201;
    }

    @NotNull
    public static final Response checkOk(@NotNull Response $this$checkOk) {
        Intrinsics.checkNotNullParameter((Object)$this$checkOk, (String)"<this>");
        int[] nArray = new int[]{200, 201};
        return ResponseKt.checkStatus($this$checkOk, nArray);
    }

    @NotNull
    public static final Response checkStatus(@NotNull Response $this$checkStatus, int ... successCodes) {
        Intrinsics.checkNotNullParameter((Object)$this$checkStatus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)successCodes, (String)"successCodes");
        if (!(successCodes.length == 0) && !ArraysKt.contains((int[])successCodes, (int)$this$checkStatus.code())) {
            throw new SlinkHttpException($this$checkStatus);
        }
        return $this$checkStatus;
    }

    @NotNull
    public static final String text(@NotNull Response $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        ResponseBody responseBody = $this$text.body();
        Intrinsics.checkNotNull((Object)responseBody);
        String string = responseBody.string();
        ResponseBody responseBody2 = $this$text.body();
        Intrinsics.checkNotNull((Object)responseBody2);
        responseBody2.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File writeTo(@NotNull Response $this$writeTo, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream output = (FileOutputStream)closeable;
            boolean bl = false;
            ResponseKt.writeTo($this$writeTo, output);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return file;
    }

    public static final void writeTo(@NotNull Response $this$writeTo, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ResponseBody responseBody = $this$writeTo.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ByteStreamsKt.copyTo$default((InputStream)responseBody.byteStream(), (OutputStream)outputStream, (int)0, (int)2, null);
        ResponseBody responseBody2 = $this$writeTo.body();
        Intrinsics.checkNotNull((Object)responseBody2);
        responseBody2.close();
    }

    public static final <T> T withBody(@NotNull Response $this$withBody, @NotNull Function2<? super Long, ? super InputStream, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)$this$withBody, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        String string = Response.header$default((Response)$this$withBody, (String)"Content-Length", null, (int)2, null);
        long contentLength = string != null ? Long.parseLong(string) : 0L;
        Long l = contentLength;
        ResponseBody responseBody = $this$withBody.body();
        Intrinsics.checkNotNull((Object)responseBody);
        Object result = handler.invoke((Object)l, (Object)responseBody.byteStream());
        ResponseBody responseBody2 = $this$withBody.body();
        Intrinsics.checkNotNull((Object)responseBody2);
        responseBody2.close();
        return (T)result;
    }
}

