/*
 * Decompiled with CFR 0.152.
 */
package org.kbods.rdf.vocabulary;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.jetbrains.annotations.NotNull;
import org.kbods.rdf.BodsRdf;
import org.kbods.rdf.vocabulary.BodsSchemaVersion;
import org.kbods.rdf.vocabulary.BodsVocabulary;
import org.kbods.rdf.vocabulary.SchemaCode;
import org.kbods.rdf.vocabulary.SchemaCodeKt;
import org.kbods.utils.HttpKt;
import org.kbods.utils.ResourcesKt;
import org.kbods.utils.TempDir;
import org.kbods.utils.UnzipKt;
import org.rdf4k.Rio_parseKt;
import org.rdf4k.Rio_writeKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J*\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00170\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00142\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/kbods/rdf/vocabulary/BodsVocabulary;", "", "()V", "CODE", "", "DESCRIPTION", "TITILE", "httpClient", "Lokhttp3/OkHttpClient;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addTopLevelDefinitions", "", "model", "Lorg/eclipse/rdf4j/model/Model;", "codeList", "", "Lorg/kbods/rdf/vocabulary/SchemaCode;", "packageDir", "Ljava/io/File;", "codeListCsv", "csvRows", "", "file", "loadVocabulary", "schemaVersion", "Lorg/kbods/rdf/vocabulary/BodsSchemaVersion;", "write", "outputFile", "repository", "Lorg/eclipse/rdf4j/repository/Repository;", "connection", "Lorg/eclipse/rdf4j/repository/RepositoryConnection;", "writer", "Lorg/eclipse/rdf4j/rio/RDFWriter;", "kbods-rdf"})
public final class BodsVocabulary {
    @NotNull
    public static final BodsVocabulary INSTANCE = new BodsVocabulary();
    @NotNull
    private static final String CODE = "code";
    @NotNull
    private static final String TITILE = "title";
    @NotNull
    private static final String DESCRIPTION = "description";
    private static final Logger log = LoggerFactory.getLogger(BodsVocabulary.class);
    @NotNull
    private static final OkHttpClient httpClient = HttpKt.httpClient$default((boolean)false, (boolean)false, (int)3, null);

    private BodsVocabulary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull Repository repository, @NotNull BodsSchemaVersion schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)((Object)schemaVersion), (String)"schemaVersion");
        AutoCloseable autoCloseable = (AutoCloseable)repository.getConnection();
        Throwable throwable = null;
        try {
            RepositoryConnection connection = (RepositoryConnection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            INSTANCE.write(connection, schemaVersion);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void write$default(BodsVocabulary bodsVocabulary, Repository repository, BodsSchemaVersion bodsSchemaVersion, int n, Object object) {
        if ((n & 2) != 0) {
            bodsSchemaVersion = BodsSchemaVersion.Companion.getBULK_REGISTER_VERSION();
        }
        bodsVocabulary.write(repository, bodsSchemaVersion);
    }

    public final void write(@NotNull RepositoryConnection connection, @NotNull BodsSchemaVersion schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)((Object)schemaVersion), (String)"schemaVersion");
        connection.add((Iterable)this.loadVocabulary(schemaVersion), new Resource[0]);
    }

    public static /* synthetic */ void write$default(BodsVocabulary bodsVocabulary, RepositoryConnection repositoryConnection, BodsSchemaVersion bodsSchemaVersion, int n, Object object) {
        if ((n & 2) != 0) {
            bodsSchemaVersion = BodsSchemaVersion.Companion.getBULK_REGISTER_VERSION();
        }
        bodsVocabulary.write(repositoryConnection, bodsSchemaVersion);
    }

    public final void write(@NotNull File outputFile, @NotNull BodsSchemaVersion schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)((Object)schemaVersion), (String)"schemaVersion");
        RDFFormat rDFFormat = RDFFormat.TURTLE;
        Intrinsics.checkNotNullExpressionValue((Object)rDFFormat, (String)"TURTLE");
        Rio_writeKt.useRdfWriter$default((File)outputFile, (RDFFormat)rDFFormat, BodsRdf.INSTANCE.getREQUIRED_NAMESPACES(), (int)0, (Function1)((Function1)new Function1<RDFWriter, Unit>(schemaVersion){
            final /* synthetic */ BodsSchemaVersion $schemaVersion;
            {
                this.$schemaVersion = $schemaVersion;
                super(1);
            }

            public final void invoke(@NotNull RDFWriter rdfWriter) {
                Intrinsics.checkNotNullParameter((Object)rdfWriter, (String)"rdfWriter");
                BodsVocabulary.INSTANCE.write(rdfWriter, this.$schemaVersion);
            }
        }), (int)4, null);
    }

    public static /* synthetic */ void write$default(BodsVocabulary bodsVocabulary, File file, BodsSchemaVersion bodsSchemaVersion, int n, Object object) {
        if ((n & 2) != 0) {
            bodsSchemaVersion = BodsSchemaVersion.Companion.getBULK_REGISTER_VERSION();
        }
        bodsVocabulary.write(file, bodsSchemaVersion);
    }

    public final void write(@NotNull RDFWriter writer, @NotNull BodsSchemaVersion schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)((Object)schemaVersion), (String)"schemaVersion");
        Iterable $this$forEach$iv = (Iterable)this.loadVocabulary(schemaVersion);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Statement statement = (Statement)element$iv;
            boolean bl = false;
            writer.handleStatement(statement);
        }
    }

    public static /* synthetic */ void write$default(BodsVocabulary bodsVocabulary, RDFWriter rDFWriter, BodsSchemaVersion bodsSchemaVersion, int n, Object object) {
        if ((n & 2) != 0) {
            bodsSchemaVersion = BodsSchemaVersion.Companion.getBULK_REGISTER_VERSION();
        }
        bodsVocabulary.write(rDFWriter, bodsSchemaVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Model loadVocabulary(BodsSchemaVersion schemaVersion) {
        String vocabularyResource = "vocabulary/bods-vocabulary-" + schemaVersion.getVersionString() + ".ttl";
        if (ResourcesKt.resourceExists((String)vocabularyResource)) {
            return Rio_parseKt.resourceToRdfModel$default((String)vocabularyResource, null, (int)2, null);
        }
        Closeable closeable = (Closeable)new TempDir(null, 1, null);
        Throwable throwable = null;
        try {
            Object object;
            block13: {
                TempDir tempDir = (TempDir)closeable;
                boolean bl = false;
                String url = "https://github.com/openownership/data-standard/zipball/" + schemaVersion.getVersionString();
                log.info("Downloading schema release from " + url);
                Response response = HttpKt.checkOk((Response)HttpKt.get$default((OkHttpClient)httpClient, (String)url, null, (int)2, null));
                File tempZip = tempDir.newFile();
                File tempUnzipDir = tempDir.newDirectory();
                tempUnzipDir.mkdirs();
                Closeable closeable2 = new FileOutputStream(tempZip);
                Throwable throwable2 = null;
                try {
                    FileOutputStream os = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    long l = ByteStreamsKt.copyTo$default((InputStream)responseBody.byteStream(), (OutputStream)os, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                UnzipKt.unzip$default((File)tempZip, (File)tempUnzipDir, null, (int)2, null);
                File[] fileArray = tempUnzipDir.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"tempUnzipDir.listFiles()");
                for (Object object2 : (Object[])fileArray) {
                    File it = (File)object2;
                    boolean bl3 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (!StringsKt.startsWith$default((String)string, (String)"openownership-data-standard", (boolean)false, (int)2, null)) continue;
                    object = object2;
                    break block13;
                }
                object = null;
            }
            Intrinsics.checkNotNull(object);
            File packageDir = (File)object;
            LinkedHashModel model = new LinkedHashModel();
            INSTANCE.addTopLevelDefinitions((Model)model);
            SchemaCodeKt.addToModel(INSTANCE.codeList(packageDir, "entityType.csv"), (Model)model, BodsRdf.INSTANCE.getTYPE_ENTITY(), (Function1<? super String, ? extends IRI>)((Function1)loadVocabulary.1.2.INSTANCE));
            Model model2 = (Model)model;
            return model2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void addTopLevelDefinitions(Model model) {
        RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        rdfParser.parse(ResourcesKt.resourceAsInput((String)"vocabulary-base.ttl"), "http://www.openrdf.org/config/repository#");
    }

    /*
     * WARNING - void declaration
     */
    private final List<SchemaCode> codeList(File packageDir, String codeListCsv) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.csvRows(packageDir, "schema/codelists/" + codeListCsv);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void row;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = row.get(CODE);
            Intrinsics.checkNotNull(v);
            String string = (String)v;
            Object v2 = row.get(TITILE);
            Intrinsics.checkNotNull(v2);
            String string2 = (String)v2;
            String string3 = (String)row.get(DESCRIPTION);
            if (string3 == null) {
                string3 = "";
            }
            collection.add(new SchemaCode(string, string2, string3));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, String>> csvRows(File packageDir, String file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CSVFormat csvFormat = CSVFormat.RFC4180.builder().build();
        CharSequence charSequence = FilesKt.readText$default((File)new File(packageDir, file), null, (int)1, null);
        Regex regex = new Regex(",\\s+\"");
        Object object = ",\"";
        String text = regex.replace(charSequence, (String)object);
        List rows = CollectionsKt.toList((Iterable)((Iterable)new CSVParser((Reader)new StringReader(text), csvFormat)));
        CSVRecord header = (CSVRecord)rows.get(0);
        object = rows.subList(1, rows.size());
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv;
            void row;
            CSVRecord cSVRecord = (CSVRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)row, (String)"row");
            Iterable $this$mapIndexed$iv = (Iterable)row;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void value;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv2;
                int n2 = n;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(TuplesKt.to((Object)header.get((int)index), (Object)value));
            }
            collection.add(MapsKt.toMap((Iterable)((List)destination$iv$iv2)));
        }
        return (List)destination$iv$iv;
    }
}

