/*
 * Decompiled with CFR 0.152.
 */
package org.kbods.rdf.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.jetbrains.annotations.NotNull;
import org.kbods.rdf.BodsRdfConfig;
import org.kbods.rdf.plugins.BodsConvertPlugin;
import org.kbods.rdf.plugins.FilePluginContext;
import org.kbods.rdf.plugins.PluginRunner;
import org.rdf4k.Rio_writeKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kbods/rdf/plugins/FilePluginRunner;", "Lorg/kbods/rdf/plugins/PluginRunner;", "config", "Lorg/kbods/rdf/BodsRdfConfig;", "outputDir", "Ljava/io/File;", "rdfFormat", "Lorg/eclipse/rdf4j/rio/RDFFormat;", "(Lorg/kbods/rdf/BodsRdfConfig;Ljava/io/File;Lorg/eclipse/rdf4j/rio/RDFFormat;)V", "contexts", "", "", "Lorg/kbods/rdf/plugins/FilePluginContext;", "close", "", "doWrite", "plugin", "Lorg/kbods/rdf/plugins/BodsConvertPlugin;", "statements", "", "Lorg/eclipse/rdf4j/model/Statement;", "kbods-rdf"})
public final class FilePluginRunner
extends PluginRunner {
    @NotNull
    private final File outputDir;
    @NotNull
    private final RDFFormat rdfFormat;
    @NotNull
    private final Map<String, FilePluginContext> contexts;

    public FilePluginRunner(@NotNull BodsRdfConfig config, @NotNull File outputDir, @NotNull RDFFormat rdfFormat) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)rdfFormat, (String)"rdfFormat");
        super(config);
        this.outputDir = outputDir;
        this.rdfFormat = rdfFormat;
        this.contexts = new LinkedHashMap();
        Iterable $this$forEach$iv = config.getPlugins$kbods_rdf().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List plugins = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = plugins;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BodsConvertPlugin plugin = (BodsConvertPlugin)element$iv2;
                boolean bl2 = false;
                String string = plugin.getName();
                List list = this.rdfFormat.getFileExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rdfFormat.fileExtensions");
                String fileName = "bods-rdf-" + string + "." + CollectionsKt.first((List)list);
                this.contexts.put(plugin.getName(), FilePluginContext.Companion.create(this.outputDir, fileName, this.rdfFormat));
            }
        }
    }

    @Override
    public void doWrite(@NotNull BodsConvertPlugin plugin, @NotNull List<? extends Statement> statements) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        FilePluginContext filePluginContext = this.contexts.get(plugin.getName());
        Intrinsics.checkNotNull((Object)filePluginContext);
        Rio_writeKt.write((RDFWriter)filePluginContext.getRdfWriter(), (Collection)statements);
    }

    @Override
    public void close() {
        Map<String, FilePluginContext> $this$forEach$iv = this.contexts;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, FilePluginContext>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FilePluginContext> element$iv;
            Map.Entry<String, FilePluginContext> entry = element$iv = iterator.next();
            boolean bl = false;
            FilePluginContext context = entry.getValue();
            context.close();
        }
    }
}

