/*
 * Decompiled with CFR 0.152.
 */
package org.kbods.elasticsearch;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \f2\u00060\u0001j\u0002`\u0002:\u0002\f\rB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/kbods/elasticsearch/BulkIndexException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "bulkResponse", "Lco/elastic/clients/elasticsearch/core/BulkResponse;", "(Lco/elastic/clients/elasticsearch/core/BulkResponse;)V", "docErrors", "", "Lorg/kbods/elasticsearch/BulkIndexException$IndexErrorDocRef;", "(Ljava/util/Collection;)V", "getDocErrors", "()Ljava/util/Collection;", "Companion", "IndexErrorDocRef", "kbods-elasticsearch"})
public final class BulkIndexException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<IndexErrorDocRef> docErrors;

    public BulkIndexException(@NotNull Collection<IndexErrorDocRef> docErrors) {
        Intrinsics.checkNotNullParameter(docErrors, (String)"docErrors");
        super("Elasticsearch bulk index error");
        this.docErrors = docErrors;
    }

    @NotNull
    public final Collection<IndexErrorDocRef> getDocErrors() {
        return this.docErrors;
    }

    public BulkIndexException(@NotNull BulkResponse bulkResponse) {
        Intrinsics.checkNotNullParameter((Object)bulkResponse, (String)"bulkResponse");
        this(BulkIndexException.Companion.errors(bulkResponse));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/kbods/elasticsearch/BulkIndexException$IndexErrorDocRef;", "", "index", "", "id", "reason", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getIndex", "getReason", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kbods-elasticsearch"})
    public static final class IndexErrorDocRef {
        @NotNull
        private final String index;
        @NotNull
        private final String id;
        @NotNull
        private final String reason;

        public IndexErrorDocRef(@NotNull String index, @NotNull String id, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.index = index;
            this.id = id;
            this.reason = reason;
        }

        @NotNull
        public final String getIndex() {
            return this.index;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final String component1() {
            return this.index;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final String component3() {
            return this.reason;
        }

        @NotNull
        public final IndexErrorDocRef copy(@NotNull String index, @NotNull String id, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new IndexErrorDocRef(index, id, reason);
        }

        public static /* synthetic */ IndexErrorDocRef copy$default(IndexErrorDocRef indexErrorDocRef, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = indexErrorDocRef.index;
            }
            if ((n & 2) != 0) {
                string2 = indexErrorDocRef.id;
            }
            if ((n & 4) != 0) {
                string3 = indexErrorDocRef.reason;
            }
            return indexErrorDocRef.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "IndexErrorDocRef(index=" + this.index + ", id=" + this.id + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result = this.index.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + this.reason.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexErrorDocRef)) {
                return false;
            }
            IndexErrorDocRef indexErrorDocRef = (IndexErrorDocRef)other;
            if (!Intrinsics.areEqual((Object)this.index, (Object)indexErrorDocRef.index)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)indexErrorDocRef.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)indexErrorDocRef.reason);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/kbods/elasticsearch/BulkIndexException$Companion;", "", "()V", "errors", "", "Lorg/kbods/elasticsearch/BulkIndexException$IndexErrorDocRef;", "bulkResponse", "Lco/elastic/clients/elasticsearch/core/BulkResponse;", "kbods-elasticsearch"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<IndexErrorDocRef> errors(BulkResponse bulkResponse) {
            void $this$mapTo$iv$iv;
            BulkResponseItem it;
            Iterable $this$filterTo$iv$iv;
            List list = bulkResponse.items();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"bulkResponse.items()");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BulkResponseItem)element$iv$iv;
                boolean bl = false;
                if (!(it.error() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void item;
                it = (BulkResponseItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = item.index();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.index()");
                String string2 = item.id();
                Intrinsics.checkNotNull((Object)string2);
                ErrorCause errorCause = item.error();
                Intrinsics.checkNotNull((Object)errorCause);
                String string3 = errorCause.reason();
                Intrinsics.checkNotNull((Object)string3);
                collection.add(new IndexErrorDocRef(string, string2, string3));
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

