package invirt.test

import io.mockk.mockkObject
import io.mockk.unmockkObject

fun <T : Any, R> withMockedObject(obj: T, block: (T) -> R): R {
    mockkObject(obj)
    try {
        return block(obj)
    } finally {
        unmockkObject(obj)
    }
}
