/*
 * Decompiled with CFR 0.152.
 */
package invirt.mongodb;

import com.mongodb.client.ClientSession;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.kotlin.client.MongoCollection;
import invirt.mongodb.IndexKt;
import invirt.mongodb.IndexesBuilder;
import invirt.mongodb.StoredEntity;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0002\u001a/\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u001a/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001f\u0010\u0015\u001a\u00020\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0016\u001a3\u0010\u0017\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b\u001a?\u0010\u0017\u001a\u00020\n\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001e2\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b\u001a\u0014\u0010\f\u001a\u00020\u0004*\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"log", "Lio/github/oshai/kotlinlogging/KLogger;", "buildIndexes", "", "Lcom/mongodb/client/model/IndexModel;", "collectionName", "", "build", "Lkotlin/Function1;", "Linvirt/mongodb/IndexesBuilder;", "", "Lkotlin/ExtensionFunctionType;", "indexAsc", "fields", "", "caseInsensitive", "", "([Ljava/lang/String;Z)Ljava/util/List;", "indexDesc", "indexOptions", "Lcom/mongodb/client/model/IndexOptions;", "textIndex", "([Ljava/lang/String;)Lcom/mongodb/client/model/IndexModel;", "createIndexes", "Lcom/mongodb/client/MongoCollection;", "clientSession", "Lcom/mongodb/client/ClientSession;", "E", "Linvirt/mongodb/StoredEntity;", "Lcom/mongodb/kotlin/client/MongoCollection;", "Lcom/mongodb/kotlin/client/ClientSession;", "invirt-mongodb"})
@SourceDebugExtension(value={"SMAP\nindex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 index.kt\ninvirt/mongodb/IndexKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n11065#2:116\n11400#2,3:117\n11065#2:120\n11400#2,3:121\n11065#2:124\n11400#2,3:125\n*S KotlinDebug\n*F\n+ 1 index.kt\ninvirt/mongodb/IndexKt\n*L\n20#1:116\n20#1:117,3\n24#1:120\n24#1:121,3\n28#1:124\n28#1:125,3\n*E\n"})
public final class IndexKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @NotNull
    public static final IndexModel indexAsc(@NotNull String $this$indexAsc, boolean caseInsensitive) {
        Intrinsics.checkNotNullParameter((Object)$this$indexAsc, (String)"<this>");
        String[] stringArray = new String[]{$this$indexAsc};
        return new IndexModel(Indexes.ascending((String[])stringArray), IndexKt.indexOptions(caseInsensitive));
    }

    public static /* synthetic */ IndexModel indexAsc$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IndexKt.indexAsc(string, bl);
    }

    @NotNull
    public static final IndexModel indexDesc(@NotNull String $this$indexDesc, boolean caseInsensitive) {
        Intrinsics.checkNotNullParameter((Object)$this$indexDesc, (String)"<this>");
        String[] stringArray = new String[]{$this$indexDesc};
        return new IndexModel(Indexes.descending((String[])stringArray), IndexKt.indexOptions(caseInsensitive));
    }

    public static /* synthetic */ IndexModel indexDesc$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IndexKt.indexDesc(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IndexModel textIndex(String ... fields) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        String[] $this$map$iv = fields;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Indexes.text((String)it));
        }
        Bson bson = Indexes.compoundIndex((List)((List)destination$iv$iv));
        return new IndexModel(bson);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IndexModel> indexAsc(@NotNull String[] fields, boolean caseInsensitive) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        String[] $this$map$iv = fields;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IndexKt.indexAsc((String)it, caseInsensitive));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List indexAsc$default(String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return IndexKt.indexAsc(stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IndexModel> indexDesc(@NotNull String[] fields, boolean caseInsensitive) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        String[] $this$map$iv = fields;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IndexKt.indexDesc((String)it, caseInsensitive));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List indexDesc$default(String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return IndexKt.indexDesc(stringArray, bl);
    }

    public static final <E extends StoredEntity> void createIndexes(@NotNull MongoCollection<E> $this$createIndexes, @Nullable com.mongodb.kotlin.client.ClientSession clientSession, @NotNull Function1<? super IndexesBuilder, Unit> build) {
        Intrinsics.checkNotNullParameter($this$createIndexes, (String)"<this>");
        Intrinsics.checkNotNullParameter(build, (String)"build");
        String string = $this$createIndexes.getNamespace().getCollectionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCollectionName(...)");
        List<IndexModel> indexes = IndexKt.buildIndexes(string, build);
        if (clientSession != null) {
            MongoCollection.createIndexes$default($this$createIndexes, (com.mongodb.kotlin.client.ClientSession)clientSession, indexes, null, (int)4, null);
        } else {
            MongoCollection.createIndexes$default($this$createIndexes, indexes, null, (int)2, null);
        }
    }

    public static /* synthetic */ void createIndexes$default(MongoCollection mongoCollection, com.mongodb.kotlin.client.ClientSession clientSession, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            clientSession = null;
        }
        IndexKt.createIndexes(mongoCollection, clientSession, (Function1<? super IndexesBuilder, Unit>)function1);
    }

    public static final void createIndexes(@NotNull com.mongodb.client.MongoCollection<?> $this$createIndexes, @Nullable ClientSession clientSession, @NotNull Function1<? super IndexesBuilder, Unit> build) {
        Intrinsics.checkNotNullParameter($this$createIndexes, (String)"<this>");
        Intrinsics.checkNotNullParameter(build, (String)"build");
        String string = $this$createIndexes.getNamespace().getCollectionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCollectionName(...)");
        List<IndexModel> indexes = IndexKt.buildIndexes(string, build);
        if (clientSession != null) {
            $this$createIndexes.createIndexes(clientSession, indexes);
        } else {
            $this$createIndexes.createIndexes(indexes);
        }
    }

    public static /* synthetic */ void createIndexes$default(com.mongodb.client.MongoCollection mongoCollection, ClientSession clientSession, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            clientSession = null;
        }
        IndexKt.createIndexes(mongoCollection, clientSession, (Function1<? super IndexesBuilder, Unit>)function1);
    }

    private static final List<IndexModel> buildIndexes(String collectionName, Function1<? super IndexesBuilder, Unit> build) {
        IndexesBuilder indexesBuilder = new IndexesBuilder();
        KProperty1[] kProperty1Array = new KProperty1[]{buildIndexes.1.INSTANCE};
        IndexesBuilder.asc$default(indexesBuilder, kProperty1Array, false, 2, null);
        kProperty1Array = new KProperty1[]{buildIndexes.2.INSTANCE};
        IndexesBuilder.desc$default(indexesBuilder, kProperty1Array, false, 2, null);
        kProperty1Array = new KProperty1[]{buildIndexes.3.INSTANCE};
        IndexesBuilder.desc$default(indexesBuilder, kProperty1Array, false, 2, null);
        build.invoke((Object)indexesBuilder);
        log.atInfo((Function1)new Function1<KLoggingEventBuilder, Unit>(collectionName, indexesBuilder){
            final /* synthetic */ String $collectionName;
            final /* synthetic */ IndexesBuilder $indexesBuilder;
            {
                this.$collectionName = $collectionName;
                this.$indexesBuilder = $indexesBuilder;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KLoggingEventBuilder $this$atInfo) {
                Collection<Bson> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$atInfo, (String)"$this$atInfo");
                $this$atInfo.setMessage("Creating indexes for collection");
                Pair[] pairArray = new Pair[3];
                pairArray[0] = TuplesKt.to((Object)"collection", (Object)this.$collectionName);
                pairArray[1] = TuplesKt.to((Object)"count", (Object)this.$indexesBuilder.getIndexes$invirt_mongodb().size());
                Iterable iterable = this.$indexesBuilder.getIndexes$invirt_mongodb();
                String string = "indexes";
                int n = 2;
                Pair[] pairArray2 = pairArray;
                KLoggingEventBuilder kLoggingEventBuilder = $this$atInfo;
                boolean $i$f$map = false;
                void var5_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IndexModel indexModel = (IndexModel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKeys());
                }
                collection = (List)destination$iv$iv;
                pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
                kLoggingEventBuilder.setPayload(MapsKt.mapOf((Pair[])pairArray));
            }
        });
        return indexesBuilder.getIndexes$invirt_mongodb();
    }

    private static final IndexOptions indexOptions(boolean caseInsensitive) {
        IndexOptions indexOptions = new IndexOptions();
        if (caseInsensitive) {
            indexOptions.collation(Collation.builder().locale("en").collationStrength(CollationStrength.SECONDARY).build());
        }
        return indexOptions;
    }
}

