/*
 * Decompiled with CFR 0.152.
 */
package invirt.mongodb;

import com.mongodb.client.model.Filters;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\u001a\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a'\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0002\u0010\b\u001a\u001c\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0004\u001a\u0018\u0010\f\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a)\u0010\u0011\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015\u001a)\u0010\u0016\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015\u001a)\u0010\u0017\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015\u001a#\u0010\u0018\u001a\u00020\u0001*\u00020\u00042\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0007\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001a\u001a\u0018\u0010\u0018\u001a\u00020\u0001*\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\t\u001a5\u0010\u0018\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00120\u0007\"\u0002H\u0012\u00a2\u0006\u0002\u0010\u001b\u001a*\u0010\u0018\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00120\t\u001a)\u0010\u001c\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015\u001a)\u0010\u001d\u001a\u00020\u0001\"\b\b\u0000\u0010\u0012*\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\r2\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u001e"}, d2={"mongoById", "Lorg/bson/conversions/Bson;", "kotlin.jvm.PlatformType", "id", "", "mongoByIds", "ids", "", "([Ljava/lang/String;)Lorg/bson/conversions/Bson;", "", "mongoTextSearch", "text", "inYear", "Lkotlin/reflect/KProperty;", "Ljava/time/LocalDate;", "year", "", "mongoEq", "Value", "", "value", "(Lkotlin/reflect/KProperty;Ljava/lang/Object;)Lorg/bson/conversions/Bson;", "mongoGt", "mongoGte", "mongoIn", "values", "(Ljava/lang/String;[Ljava/lang/Object;)Lorg/bson/conversions/Bson;", "(Lkotlin/reflect/KProperty;[Ljava/lang/Object;)Lorg/bson/conversions/Bson;", "mongoLt", "mongoLte", "invirt-mongodb"})
@SourceDebugExtension(value={"SMAP\nfilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 filters.kt\ninvirt/mongodb/FiltersKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,36:1\n37#2,2:37\n*S KotlinDebug\n*F\n+ 1 filters.kt\ninvirt/mongodb/FiltersKt\n*L\n10#1:37,2\n*E\n"})
public final class FiltersKt {
    public static final Bson mongoById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Filters.eq((String)"_id", (Object)id);
    }

    public static final Bson mongoByIds(String ... ids) {
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        return Filters.in((String)"_id", (Object[])Arrays.copyOf(ids, ids.length));
    }

    public static final Bson mongoByIds(@NotNull Collection<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Collection<String> $this$toTypedArray$iv = ids;
        boolean $i$f$toTypedArray = false;
        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return FiltersKt.mongoByIds(Arrays.copyOf(stringArray, stringArray.length));
    }

    @NotNull
    public static final <Value> Bson mongoEq(@NotNull KProperty<? extends Value> $this$mongoEq, @NotNull Value value) {
        Intrinsics.checkNotNullParameter($this$mongoEq, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Bson bson = Filters.eq((String)$this$mongoEq.getName(), value);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"eq(...)");
        return bson;
    }

    @NotNull
    public static final <Value> Bson mongoGt(@NotNull KProperty<? extends Value> $this$mongoGt, @NotNull Value value) {
        Intrinsics.checkNotNullParameter($this$mongoGt, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Bson bson = Filters.gt((String)$this$mongoGt.getName(), value);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gt(...)");
        return bson;
    }

    @NotNull
    public static final <Value> Bson mongoGte(@NotNull KProperty<? extends Value> $this$mongoGte, @NotNull Value value) {
        Intrinsics.checkNotNullParameter($this$mongoGte, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Bson bson = Filters.gte((String)$this$mongoGte.getName(), value);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"gte(...)");
        return bson;
    }

    @NotNull
    public static final <Value> Bson mongoLt(@NotNull KProperty<? extends Value> $this$mongoLt, @NotNull Value value) {
        Intrinsics.checkNotNullParameter($this$mongoLt, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Bson bson = Filters.lt((String)$this$mongoLt.getName(), value);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"lt(...)");
        return bson;
    }

    @NotNull
    public static final <Value> Bson mongoLte(@NotNull KProperty<? extends Value> $this$mongoLte, @NotNull Value value) {
        Intrinsics.checkNotNullParameter($this$mongoLte, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Bson bson = Filters.lte((String)$this$mongoLte.getName(), value);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"lte(...)");
        return bson;
    }

    @NotNull
    public static final <Value> Bson mongoIn(@NotNull KProperty<? extends Value> $this$mongoIn, Value ... values) {
        Intrinsics.checkNotNullParameter($this$mongoIn, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return FiltersKt.mongoIn($this$mongoIn.getName(), ArraysKt.toList((Object[])values));
    }

    @NotNull
    public static final <Value> Bson mongoIn(@NotNull KProperty<? extends Value> $this$mongoIn, @NotNull Collection<? extends Value> values) {
        Intrinsics.checkNotNullParameter($this$mongoIn, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return FiltersKt.mongoIn($this$mongoIn.getName(), values);
    }

    @NotNull
    public static final Bson mongoIn(@NotNull String $this$mongoIn, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)$this$mongoIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return FiltersKt.mongoIn($this$mongoIn, ArraysKt.toList((Object[])values));
    }

    @NotNull
    public static final Bson mongoIn(@NotNull String $this$mongoIn, @NotNull Collection<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)$this$mongoIn, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Values for mongoIn cannot be empty");
        }
        Bson bson = Filters.in((String)$this$mongoIn, (Iterable)values);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"in(...)");
        return bson;
    }

    @NotNull
    public static final Bson mongoTextSearch(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson bson = Filters.text((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"text(...)");
        return bson;
    }

    @NotNull
    public static final Bson inYear(@NotNull KProperty<LocalDate> $this$inYear, int year) {
        Intrinsics.checkNotNullParameter($this$inYear, (String)"<this>");
        Bson[] bsonArray = new Bson[]{FiltersKt.mongoGte($this$inYear, LocalDate.of(year, 1, 1)), FiltersKt.mongoLte($this$inYear, LocalDate.of(year, 12, 31))};
        Bson bson = Filters.and((Bson[])bsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"and(...)");
        return bson;
    }
}

