/*
 * Decompiled with CFR 0.152.
 */
package invirt.mongodb;

import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.kotlin.client.ClientSession;
import com.mongodb.kotlin.client.MongoClient;
import com.mongodb.kotlin.client.MongoDatabase;
import invirt.mongodb.MongoKt;
import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bson.BsonInt64;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u001b\u0010\u000f\u001a\u00020\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Linvirt/mongodb/Mongo;", "", "connectionString", "", "(Ljava/lang/String;)V", "getConnectionString", "()Ljava/lang/String;", "database", "Lcom/mongodb/kotlin/client/MongoDatabase;", "getDatabase", "()Lcom/mongodb/kotlin/client/MongoDatabase;", "database$delegate", "Lkotlin/Lazy;", "databaseName", "getDatabaseName", "mongoClient", "Lcom/mongodb/kotlin/client/MongoClient;", "getMongoClient$invirt_mongodb", "()Lcom/mongodb/kotlin/client/MongoClient;", "mongoClient$delegate", "runInTransaction", "Result", "block", "Lkotlin/Function1;", "Lcom/mongodb/kotlin/client/ClientSession;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "invirt-mongodb"})
public final class Mongo {
    @NotNull
    private final String connectionString;
    @NotNull
    private final String databaseName;
    @NotNull
    private final Lazy mongoClient$delegate;
    @NotNull
    private final Lazy database$delegate;

    public Mongo(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        this.connectionString = connectionString;
        String string = new URI(this.connectionString).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("^/");
        String string2 = "";
        this.databaseName = regex.replace(charSequence, string2);
        this.mongoClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MongoClient>(this){
            final /* synthetic */ Mongo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MongoClient invoke() {
                return MongoClient.Factory.create(this.this$0.getConnectionString());
            }
        }));
        this.database$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MongoDatabase>(this){
            final /* synthetic */ Mongo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MongoDatabase invoke() {
                MongoDatabase db = this.this$0.getMongoClient$invirt_mongodb().getDatabase(this.this$0.getDatabaseName());
                MongoDatabase.runCommand$default((MongoDatabase)db, (Bson)((Bson)new Document("ping", (Object)new BsonInt64(1L))), null, (int)2, null);
                MongoKt.access$getLog$p().info((Function0)new Function0<Object>(this.this$0){
                    final /* synthetic */ Mongo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Successfully pinged MongoDB database '" + this.this$0.getDatabaseName() + "'";
                    }
                });
                return db;
            }
        }));
        MongoKt.access$getLog$p().info((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                CharSequence charSequence = this.getConnectionString();
                Regex regex = new Regex("://.*@");
                String string = "://*****@";
                return "MongoDB connection string: " + regex.replace(charSequence, string);
            }
        });
        if (((CharSequence)this.databaseName).length() == 0) {
            throw new IllegalArgumentException("Database missing from connection string");
        }
    }

    @NotNull
    public final String getConnectionString() {
        return this.connectionString;
    }

    @NotNull
    public final String getDatabaseName() {
        return this.databaseName;
    }

    @NotNull
    public final MongoClient getMongoClient$invirt_mongodb() {
        Lazy lazy = this.mongoClient$delegate;
        return (MongoClient)lazy.getValue();
    }

    @NotNull
    public final MongoDatabase getDatabase() {
        Lazy lazy = this.database$delegate;
        return (MongoDatabase)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <Result> Result runInTransaction(@NotNull Function1<? super ClientSession, ? extends Result> block) {
        void var3_3;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try (ClientSession session = MongoClient.startSession$default((MongoClient)this.getMongoClient$invirt_mongodb(), null, (int)1, null);){
            TransactionOptions transactionOptions = TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build();
            Intrinsics.checkNotNullExpressionValue((Object)transactionOptions, (String)"build(...)");
            session.startTransaction(transactionOptions);
            Object result = block.invoke((Object)session);
            session.commitTransaction();
        }
        return var3_3;
    }
}

