/*
 * Decompiled with CFR 0.152.
 */
package invirt.mongodb;

import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.kotlin.client.ClientSession;
import com.mongodb.kotlin.client.MongoCollection;
import invirt.mongodb.FiltersKt;
import invirt.mongodb.StoredEntity;
import invirt.mongodb.StoredEntityKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a)\u0010\u0007\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a)\u0010\u000b\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u001a'\u0010\r\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u000e\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000f\u001a*\u0010\u0010\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006\u001a/\u0010\u0013\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"delete", "", "E", "Linvirt/mongodb/StoredEntity;", "Lcom/mongodb/kotlin/client/MongoCollection;", "id", "", "findOne", "filter", "Lorg/bson/conversions/Bson;", "(Lcom/mongodb/kotlin/client/MongoCollection;Lorg/bson/conversions/Bson;)Linvirt/mongodb/StoredEntity;", "get", "(Lcom/mongodb/kotlin/client/MongoCollection;Ljava/lang/String;)Linvirt/mongodb/StoredEntity;", "save", "entity", "(Lcom/mongodb/kotlin/client/MongoCollection;Linvirt/mongodb/StoredEntity;)Linvirt/mongodb/StoredEntity;", "txDelete", "session", "Lcom/mongodb/kotlin/client/ClientSession;", "txSave", "(Lcom/mongodb/kotlin/client/MongoCollection;Lcom/mongodb/kotlin/client/ClientSession;Linvirt/mongodb/StoredEntity;)Linvirt/mongodb/StoredEntity;", "invirt-mongodb"})
public final class CollectionKt {
    @NotNull
    public static final <E extends StoredEntity> E save(@NotNull MongoCollection<E> $this$save, @NotNull E entity) {
        Intrinsics.checkNotNullParameter($this$save, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Bson bson = FiltersKt.byId(entity.getId());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        E e = StoredEntityKt.updated(entity);
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        $this$save.replaceOne(bson, e, replaceOptions);
        return entity;
    }

    @NotNull
    public static final <E extends StoredEntity> E txSave(@NotNull MongoCollection<E> $this$txSave, @NotNull ClientSession session, @NotNull E entity) {
        Intrinsics.checkNotNullParameter($this$txSave, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Bson bson = FiltersKt.byId(entity.getId());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        E e = StoredEntityKt.updated(entity);
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        $this$txSave.replaceOne(session, bson, e, replaceOptions);
        return entity;
    }

    @Nullable
    public static final <E extends StoredEntity> E get(@NotNull MongoCollection<E> $this$get, @NotNull String id) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Bson bson = FiltersKt.byId(id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        return CollectionKt.findOne($this$get, bson);
    }

    @Nullable
    public static final <E extends StoredEntity> E findOne(@NotNull MongoCollection<E> $this$findOne, @NotNull Bson filter) {
        Intrinsics.checkNotNullParameter($this$findOne, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        List list = $this$findOne.findAsT(filter).toList();
        if (list.size() > 1) {
            throw new IllegalStateException("More than one document found for filter " + filter);
        }
        return (E)((StoredEntity)CollectionsKt.firstOrNull((List)list));
    }

    public static final <E extends StoredEntity> boolean delete(@NotNull MongoCollection<E> $this$delete, @NotNull String id) {
        Intrinsics.checkNotNullParameter($this$delete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Bson bson = FiltersKt.byId(id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        return MongoCollection.deleteOne$default($this$delete, (Bson)bson, null, (int)2, null).getDeletedCount() == 1L;
    }

    public static final <E extends StoredEntity> boolean txDelete(@NotNull MongoCollection<E> $this$txDelete, @NotNull ClientSession session, @NotNull String id) {
        Intrinsics.checkNotNullParameter($this$txDelete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Bson bson = FiltersKt.byId(id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        return MongoCollection.deleteOne$default($this$txDelete, (ClientSession)session, (Bson)bson, null, (int)4, null).getDeletedCount() == 1L;
    }
}

