/*
 * Decompiled with CFR 0.152.
 */
package invirt.data.mongodb;

import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.kotlin.client.MongoCollection;
import com.mongodb.kotlin.client.MongoDatabase;
import invirt.data.mongodb.CollectionName;
import invirt.data.mongodb.FilterKt;
import invirt.data.mongodb.MongoEntity;
import invirt.data.mongodb.TimestampedEntity;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003H\u0086\b\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\bH\u0086\b\u001a'\u0010\t\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00072\u0006\u0010\n\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"collectionName", "", "T", "Linvirt/data/mongodb/MongoEntity;", "mongoNow", "Ljava/time/Instant;", "collection", "Lcom/mongodb/kotlin/client/MongoCollection;", "Lcom/mongodb/kotlin/client/MongoDatabase;", "save", "entity", "(Lcom/mongodb/kotlin/client/MongoCollection;Linvirt/data/mongodb/MongoEntity;)Linvirt/data/mongodb/MongoEntity;", "invirt-mongodb"})
@SourceDebugExtension(value={"SMAP\nMongoEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoEntity.kt\ninvirt/data/mongodb/MongoEntityKt\n+ 2 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MongoDatabase.kt\ncom/mongodb/kotlin/client/MongoDatabase\n*L\n1#1,49:1\n28#1:53\n29#1,2:57\n20#2:50\n20#2:54\n288#3,2:51\n288#3,2:55\n118#4:59\n*S KotlinDebug\n*F\n+ 1 MongoEntity.kt\ninvirt/data/mongodb/MongoEntityKt\n*L\n42#1:53\n42#1:57,2\n28#1:50\n42#1:54\n28#1:51,2\n42#1:55,2\n42#1:59\n*E\n"})
public final class MongoEntityKt {
    public static final /* synthetic */ <T extends MongoEntity> String collectionName() {
        Object v0;
        block2: {
            boolean $i$f$collectionName = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(MongoEntity.class);
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof CollectionName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        CollectionName collectionName = (CollectionName)((Annotation)v0);
        if (collectionName == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException("Class " + Reflection.getOrCreateKotlinClass(MongoEntity.class) + " doesn't have an @CollectionName annotation");
        }
        CollectionName annotation = collectionName;
        return annotation.name();
    }

    @NotNull
    public static final <T extends MongoEntity> T save(@NotNull MongoCollection<T> $this$save, @NotNull T entity) {
        Intrinsics.checkNotNullParameter($this$save, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (entity instanceof TimestampedEntity) {
            ((TimestampedEntity)entity).setUpdatedAt(MongoEntityKt.mongoNow());
        }
        Bson bson = FilterKt.byId(entity.getId());
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        $this$save.replaceOne(bson, entity, replaceOptions);
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends MongoEntity> MongoCollection<T> collection(MongoDatabase $this$collection) {
        void this_$iv;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$collection, (String)"<this>");
            boolean $i$f$collection = false;
            MongoDatabase mongoDatabase = $this$collection;
            boolean $i$f$collectionName = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KAnnotatedElement $this$findAnnotation$iv$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(MongoEntity.class);
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                boolean bl = false;
                if (!(it$iv$iv instanceof CollectionName)) continue;
                v0 = element$iv$iv$iv;
                break block2;
            }
            v0 = null;
        }
        CollectionName collectionName = (CollectionName)((Annotation)v0);
        if (collectionName == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException("Class " + Reflection.getOrCreateKotlinClass(MongoEntity.class) + " doesn't have an @CollectionName annotation");
        }
        CollectionName annotation$iv = collectionName;
        String collectionName$iv = annotation$iv.name();
        boolean $i$f$getCollection = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this_$iv.getCollection(collectionName$iv, Object.class);
    }

    @NotNull
    public static final Instant mongoNow() {
        Instant instant = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"truncatedTo(...)");
        return instant;
    }
}

