package invirt.data.mongodb

import com.mongodb.ConnectionString
import com.mongodb.kotlin.client.MongoClient
import com.mongodb.kotlin.client.MongoCollection
import com.mongodb.kotlin.client.MongoDatabase
import io.github.oshai.kotlinlogging.KotlinLogging
import org.bson.BsonInt64
import org.bson.Document

private val log = KotlinLogging.logger {}

fun mongoDatabase(connectionString: String): MongoDatabase {
    log.info { "MongoDB connection string: ${connectionString.replace("://.*@".toRegex(), "://*****@")}" }
    val client = MongoClient.create(connectionString)
    val connectionStr = ConnectionString(connectionString)
    val databaseName = connectionStr.database!!

    val database = client.getDatabase(databaseName)
    database.runCommand(Document("ping", BsonInt64(1)))
    log.info { "Successfully pinged MongoDB database '${databaseName}' at '${connectionStr.hosts.joinToString(", ")}'" }
    return database
}

inline fun <reified T : MongoEntity> MongoDatabase.getEntityCollection(): MongoCollection<T> {
    val collection = getCollection<T>(collectionName<T>())
    collection.createEntityIndexes()
    return collection
}
