/*
 * Decompiled with CFR 0.152.
 */
package invirt.data.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.kotlin.client.MongoClient;
import com.mongodb.kotlin.client.MongoCollection;
import com.mongodb.kotlin.client.MongoDatabase;
import invirt.data.mongodb.CollectionName;
import invirt.data.mongodb.IndexKt;
import invirt.data.mongodb.MongoDbKt;
import invirt.data.mongodb.MongoEntity;
import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.text.Regex;
import org.bson.BsonInt64;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u0010H\u0086\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Linvirt/data/mongodb/MongoDb;", "", "connectionString", "", "(Ljava/lang/String;)V", "client", "Lcom/mongodb/kotlin/client/MongoClient;", "database", "Lcom/mongodb/kotlin/client/MongoDatabase;", "getDatabase", "()Lcom/mongodb/kotlin/client/MongoDatabase;", "close", "", "getCollection", "Lcom/mongodb/kotlin/client/MongoCollection;", "T", "Linvirt/data/mongodb/MongoEntity;", "invirt-mongodb"})
@SourceDebugExtension(value={"SMAP\nMongoDb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDb.kt\ninvirt/data/mongodb/MongoDb\n+ 2 MongoEntity.kt\ninvirt/data/mongodb/MongoEntityKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MongoDatabase.kt\ncom/mongodb/kotlin/client/MongoDatabase\n*L\n1#1,39:1\n28#2:40\n29#2,2:44\n20#3:41\n288#4,2:42\n118#5:46\n*S KotlinDebug\n*F\n+ 1 MongoDb.kt\ninvirt/data/mongodb/MongoDb\n*L\n30#1:40\n30#1:44,2\n30#1:41\n30#1:42,2\n30#1:46\n*E\n"})
public final class MongoDb {
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private final MongoClient client;

    public MongoDb(final @NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        MongoDbKt.access$getLog$p().info((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                CharSequence charSequence = connectionString;
                Regex regex = new Regex("://.*@");
                String string = "://*****@";
                return "MongoDB connection string: " + regex.replace(charSequence, string);
            }
        });
        this.client = MongoClient.Factory.create(connectionString);
        final ConnectionString connection = new ConnectionString(connectionString);
        String string = connection.getDatabase();
        Intrinsics.checkNotNull((Object)string);
        final String databaseName = string;
        this.database = this.client.getDatabase(databaseName);
        MongoDatabase.runCommand$default((MongoDatabase)this.database, (Bson)((Bson)new Document("ping", (Object)new BsonInt64(1L))), null, (int)2, null);
        MongoDbKt.access$getLog$p().info((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                List list = connection.getHosts();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHosts(...)");
                return "Successfully pinged MongoDB database '" + databaseName + "' at '" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "'";
            }
        });
    }

    @NotNull
    public final MongoDatabase getDatabase() {
        return this.database;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends MongoEntity> MongoCollection<T> getCollection() {
        void collectionName$iv;
        void this_$iv;
        Object v0;
        block2: {
            boolean $i$f$getCollection = false;
            MongoDatabase mongoDatabase = this.getDatabase();
            boolean $i$f$collectionName = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KAnnotatedElement $this$findAnnotation$iv$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(MongoEntity.class);
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                boolean bl = false;
                if (!(it$iv$iv instanceof CollectionName)) continue;
                v0 = element$iv$iv$iv;
                break block2;
            }
            v0 = null;
        }
        CollectionName collectionName = (CollectionName)((Annotation)v0);
        if (collectionName == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException("Class " + Reflection.getOrCreateKotlinClass(MongoEntity.class) + " doesn't have an @CollectionName annotation");
        }
        CollectionName annotation$iv = collectionName;
        String $i$f$collectionName = annotation$iv.name();
        boolean $i$f$getCollection = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        MongoCollection collection = this_$iv.getCollection((String)collectionName$iv, Object.class);
        IndexKt.createIndexes(collection);
        return collection;
    }

    public final void close() {
        this.client.close();
    }
}

