/*
 * Decompiled with CFR 0.152.
 */
package invirt.data.mongodb;

import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.kotlin.client.MongoCollection;
import invirt.data.mongodb.FilterKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\"\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a)\u0010\u0007\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a)\u0010\u000b\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u001a/\u0010\r\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"delete", "", "T", "", "Lcom/mongodb/kotlin/client/MongoCollection;", "id", "", "findOne", "filter", "Lorg/bson/conversions/Bson;", "(Lcom/mongodb/kotlin/client/MongoCollection;Lorg/bson/conversions/Bson;)Ljava/lang/Object;", "get", "(Lcom/mongodb/kotlin/client/MongoCollection;Ljava/lang/String;)Ljava/lang/Object;", "save", "entity", "(Lcom/mongodb/kotlin/client/MongoCollection;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "invirt-mongodb"})
public final class CollectionKt {
    @Nullable
    public static final <T> T findOne(@NotNull MongoCollection<T> $this$findOne, @NotNull Bson filter) {
        Intrinsics.checkNotNullParameter($this$findOne, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        List list = $this$findOne.findAsT(filter).toList();
        if (list.size() > 1) {
            throw new IllegalStateException("More than one document found for filter " + filter);
        }
        return (T)CollectionsKt.firstOrNull((List)list);
    }

    @Nullable
    public static final <T> T get(@NotNull MongoCollection<T> $this$get, @NotNull String id) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Bson bson = FilterKt.byId(id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        return CollectionKt.findOne($this$get, bson);
    }

    public static final <T> boolean delete(@NotNull MongoCollection<T> $this$delete, @NotNull String id) {
        Intrinsics.checkNotNullParameter($this$delete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Bson bson = FilterKt.byId(id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        return MongoCollection.deleteOne$default($this$delete, (Bson)bson, null, (int)2, null).getDeletedCount() == 1L;
    }

    @NotNull
    public static final <T> T save(@NotNull MongoCollection<T> $this$save, @NotNull String id, @NotNull T entity) {
        Intrinsics.checkNotNullParameter($this$save, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Bson bson = FilterKt.byId(id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"byId(...)");
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        $this$save.replaceOne(bson, entity, replaceOptions);
        return entity;
    }
}

