package invirt.data.mongodb

import com.mongodb.client.model.Filters
import org.bson.conversions.Bson
import kotlin.reflect.KProperty

fun byId(id: String) = Filters.eq("_id", id)
fun byIds(vararg ids: String) = Filters.`in`("_id", *ids)
fun byIds(ids: Collection<String>) = byIds(*ids.toTypedArray())

fun KProperty<*>.eq(value: Any): Bson = Filters.eq(this.name, value)
fun KProperty<*>.gt(value: Any): Bson = Filters.gt(this.name, value)
fun KProperty<*>.gte(value: Any): Bson = Filters.gte(this.name, value)
fun KProperty<*>.lt(value: Any): Bson = Filters.lt(this.name, value)
fun KProperty<*>.lte(value: Any): Bson = Filters.lte(this.name, value)
fun KProperty<*>.`in`(vararg values: Any): Bson = Filters.`in`(this.name, *values)
fun KProperty<*>.`in`(values: Collection<Any>): Bson = Filters.`in`(this.name, *values.toTypedArray())
fun textSearch(text: String): Bson = Filters.text(text)
