/*
 * Decompiled with CFR 0.152.
 */
package invirt.mongodb;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Polygon;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.kotlin.client.FindIterable;
import invirt.data.CompoundFilter;
import invirt.data.FieldFilter;
import invirt.data.Filter;
import invirt.data.Page;
import invirt.data.Sort;
import invirt.data.SortOrder;
import invirt.data.geo.GeoBoundingBox;
import invirt.data.geo.GeoLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020\u00070\b\u001a\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\n\u0012\u0006\b\u0001\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\n\u001a;\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0014\b\u0002\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\t\"\u00020\u0007\u00a2\u0006\u0002\u0010\f\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u0006\"\b\b\u0000\u0010\u0011*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00110\u0012H\u0002\u001a\n\u0010\u0010\u001a\u00020\u0006*\u00020\u0013\u00a8\u0006\u0014"}, d2={"page", "Lcom/mongodb/kotlin/client/FindIterable;", "T", "", "Linvirt/data/Page;", "mongoSort", "Lorg/bson/conversions/Bson;", "Linvirt/data/Sort;", "", "", "([Linvirt/data/Sort;)Lorg/bson/conversions/Bson;", "sort", "(Lcom/mongodb/kotlin/client/FindIterable;[Linvirt/data/Sort;)Lcom/mongodb/kotlin/client/FindIterable;", "toPosition", "Lcom/mongodb/client/model/geojson/Position;", "Linvirt/data/geo/GeoLocation;", "mongoFilter", "Value", "Linvirt/data/FieldFilter;", "Linvirt/data/Filter;", "invirt-mongodb"})
@SourceDebugExtension(value={"SMAP\ndata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 data.kt\ninvirt/mongodb/DataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n1557#2:85\n1628#2,3:86\n1557#2:93\n1628#2,3:94\n1557#2:97\n1628#2,3:98\n1557#2:101\n1628#2,3:102\n11102#3:89\n11437#3,3:90\n*S KotlinDebug\n*F\n+ 1 data.kt\ninvirt/mongodb/DataKt\n*L\n27#1:85\n27#1:86,3\n65#1:93\n65#1:94,3\n76#1:97\n76#1:98,3\n77#1:101\n77#1:102,3\n35#1:89\n35#1:90,3\n*E\n"})
public final class DataKt {
    @NotNull
    public static final <T> FindIterable<T> page(@NotNull FindIterable<T> $this$page, @NotNull Page page) {
        Intrinsics.checkNotNullParameter($this$page, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return $this$page.skip(page.getFrom()).limit(page.getSize());
    }

    @NotNull
    public static final Bson mongoSort(@NotNull Sort $this$mongoSort) {
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)$this$mongoSort, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mongoSort.getOrder().ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{$this$mongoSort.getField()};
                Bson bson2 = Sorts.ascending((String[])stringArray);
                bson = bson2;
                Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"ascending(...)");
                break;
            }
            case 2: {
                String[] stringArray = new String[]{$this$mongoSort.getField()};
                Bson bson3 = Sorts.descending((String[])stringArray);
                bson = bson3;
                Intrinsics.checkNotNullExpressionValue((Object)bson3, (String)"descending(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Bson mongoSort(@NotNull List<Sort> $this$mongoSort) {
        Bson bson;
        Intrinsics.checkNotNullParameter($this$mongoSort, (String)"<this>");
        if (!((Collection)$this$mongoSort).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$mongoSort;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Sort sort = (Sort)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DataKt.mongoSort((Sort)it));
            }
            bson = Sorts.orderBy((List)((List)destination$iv$iv));
        } else {
            bson = null;
        }
        return bson;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Bson mongoSort(@NotNull Sort[] $this$mongoSort) {
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)$this$mongoSort, (String)"<this>");
        if (!($this$mongoSort.length == 0)) {
            void $this$mapTo$iv$iv;
            Sort[] $this$map$iv = $this$mongoSort;
            boolean $i$f$map = false;
            Sort[] sortArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DataKt.mongoSort((Sort)it));
            }
            bson = Sorts.orderBy((List)((List)destination$iv$iv));
        } else {
            bson = null;
        }
        return bson;
    }

    @NotNull
    public static final <T> FindIterable<T> sort(@NotNull FindIterable<T> $this$sort, Sort ... sort) {
        Intrinsics.checkNotNullParameter($this$sort, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return !(sort.length == 0) ? $this$sort.sort(DataKt.mongoSort(ArraysKt.toList((Object[])sort))) : $this$sort;
    }

    public static /* synthetic */ FindIterable sort$default(FindIterable findIterable, Sort[] sortArray, int n, Object object) {
        if ((n & 1) != 0) {
            sortArray = new Sort[]{};
        }
        return DataKt.sort(findIterable, sortArray);
    }

    private static final Position toPosition(GeoLocation $this$toPosition) {
        return new Position($this$toPosition.getLng(), $this$toPosition.getLat(), new double[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final <Value> Bson mongoFilter(FieldFilter<Value> $this$mongoFilter) {
        Bson bson;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$mongoFilter.getOperation().ordinal()]) {
            case 1: {
                Bson bson2 = Filters.eq((String)$this$mongoFilter.getField(), (Object)$this$mongoFilter.getValue());
                bson = bson2;
                Intrinsics.checkNotNullExpressionValue((Object)bson2, (String)"eq(...)");
                break;
            }
            case 2: {
                Bson bson3 = Filters.gt((String)$this$mongoFilter.getField(), (Object)$this$mongoFilter.getValue());
                bson = bson3;
                Intrinsics.checkNotNullExpressionValue((Object)bson3, (String)"gt(...)");
                break;
            }
            case 3: {
                Bson bson4 = Filters.gte((String)$this$mongoFilter.getField(), (Object)$this$mongoFilter.getValue());
                bson = bson4;
                Intrinsics.checkNotNullExpressionValue((Object)bson4, (String)"gte(...)");
                break;
            }
            case 4: {
                Bson bson5 = Filters.lte((String)$this$mongoFilter.getField(), (Object)$this$mongoFilter.getValue());
                bson = bson5;
                Intrinsics.checkNotNullExpressionValue((Object)bson5, (String)"lte(...)");
                break;
            }
            case 5: {
                Bson bson6 = Filters.lt((String)$this$mongoFilter.getField(), (Object)$this$mongoFilter.getValue());
                bson = bson6;
                Intrinsics.checkNotNullExpressionValue((Object)bson6, (String)"lt(...)");
                break;
            }
            case 6: {
                Bson bson7 = Filters.ne((String)$this$mongoFilter.getField(), (Object)$this$mongoFilter.getValue());
                bson = bson7;
                Intrinsics.checkNotNullExpressionValue((Object)bson7, (String)"ne(...)");
                break;
            }
            case 7: {
                Bson bson8 = Filters.exists((String)$this$mongoFilter.getField());
                bson = bson8;
                Intrinsics.checkNotNullExpressionValue((Object)bson8, (String)"exists(...)");
                break;
            }
            case 8: {
                Bson bson9 = Filters.exists((String)$this$mongoFilter.getField(), (boolean)false);
                bson = bson9;
                Intrinsics.checkNotNullExpressionValue((Object)bson9, (String)"exists(...)");
                break;
            }
            case 9: {
                void $this$mapTo$iv$iv;
                Object object = $this$mongoFilter.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type invirt.data.geo.GeoBoundingBox");
                GeoBoundingBox geoBounds = (GeoBoundingBox)object;
                Iterable $this$map$iv = CollectionsKt.plus((Collection)geoBounds.getPoints(), (Object)geoBounds.getSouthWest());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GeoLocation geoLocation = (GeoLocation)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DataKt.toPosition((GeoLocation)it));
                }
                List positions = (List)destination$iv$iv;
                Bson bson10 = Filters.geoWithin((String)$this$mongoFilter.getField(), (Geometry)((Geometry)new Polygon(positions, new List[0])));
                Intrinsics.checkNotNull((Object)bson10);
                bson = bson10;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bson;
    }

    @NotNull
    public static final Bson mongoFilter(@NotNull Filter $this$mongoFilter) {
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)$this$mongoFilter, (String)"<this>");
        Filter filter = $this$mongoFilter;
        if (filter instanceof FieldFilter) {
            bson = DataKt.mongoFilter((FieldFilter)$this$mongoFilter);
        } else if (filter instanceof CompoundFilter) {
            Bson bson2 = switch (WhenMappings.$EnumSwitchMapping$2[((CompoundFilter)$this$mongoFilter).getOperator().ordinal()]) {
                case 1 -> {
                    Filter it;
                    Collection var12_11;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ((CompoundFilter)$this$mongoFilter).getChildren();
                    boolean $i$f$map = false;
                    Iterable var5_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Filter var10_9 = (Filter)item$iv$iv;
                        var12_11 = destination$iv$iv;
                        boolean $i$a$-map-DataKt$mongoFilter$1 = false;
                        var12_11.add(DataKt.mongoFilter(it));
                    }
                    yield Filters.or((Iterable)((List)destination$iv$iv));
                }
                case 2 -> {
                    Filter it;
                    Collection var12_11;
                    Iterable $this$map$iv = ((CompoundFilter)$this$mongoFilter).getChildren();
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Filter)item$iv$iv;
                        var12_11 = destination$iv$iv;
                        boolean $i$a$-map-DataKt$mongoFilter$2 = false;
                        var12_11.add(DataKt.mongoFilter(it));
                    }
                    yield Filters.and((Iterable)((List)destination$iv$iv));
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)bson2);
            bson = bson2;
        } else {
            throw new IllegalArgumentException("Unknown filter type " + Reflection.getOrCreateKotlinClass($this$mongoFilter.getClass()));
        }
        return bson;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FieldFilter.Operation.values().length];
            try {
                nArray[FieldFilter.Operation.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.GT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.GTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.LTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.LT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.NE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.EXISTS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.DOESNT_EXIST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldFilter.Operation.WITHIN_GEO_BOUNDS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CompoundFilter.Operator.values().length];
            try {
                nArray[CompoundFilter.Operator.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompoundFilter.Operator.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

