/*
 * Decompiled with CFR 0.152.
 */
package invirt.mongodb;

import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.kotlin.client.ClientSession;
import com.mongodb.kotlin.client.MongoClient;
import com.mongodb.kotlin.client.MongoDatabase;
import invirt.mongodb.MongoKt;
import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bson.BsonInt64;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00160\u0018\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Linvirt/mongodb/Mongo;", "", "connectionString", "", "<init>", "(Ljava/lang/String;)V", "getConnectionString", "()Ljava/lang/String;", "databaseName", "getDatabaseName", "mongoClient", "Lcom/mongodb/kotlin/client/MongoClient;", "getMongoClient$invirt_mongodb", "()Lcom/mongodb/kotlin/client/MongoClient;", "mongoClient$delegate", "Lkotlin/Lazy;", "database", "Lcom/mongodb/kotlin/client/MongoDatabase;", "getDatabase", "()Lcom/mongodb/kotlin/client/MongoDatabase;", "database$delegate", "runInTransaction", "Result", "block", "Lkotlin/Function1;", "Lcom/mongodb/kotlin/client/ClientSession;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "invirt-mongodb"})
public final class Mongo {
    @NotNull
    private final String connectionString;
    @NotNull
    private final String databaseName;
    @NotNull
    private final Lazy mongoClient$delegate;
    @NotNull
    private final Lazy database$delegate;

    public Mongo(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        this.connectionString = connectionString;
        String string = new URI(this.connectionString).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("^/");
        String string2 = "";
        this.databaseName = regex.replace(charSequence, string2);
        this.mongoClient$delegate = LazyKt.lazy(() -> Mongo.mongoClient_delegate$lambda$0(this));
        this.database$delegate = LazyKt.lazy(() -> Mongo.database_delegate$lambda$2(this));
        MongoKt.access$getLog$p().info(() -> Mongo._init_$lambda$3(this));
        if (((CharSequence)this.databaseName).length() == 0) {
            throw new IllegalArgumentException("Database missing from connection string");
        }
    }

    @NotNull
    public final String getConnectionString() {
        return this.connectionString;
    }

    @NotNull
    public final String getDatabaseName() {
        return this.databaseName;
    }

    @NotNull
    public final MongoClient getMongoClient$invirt_mongodb() {
        Lazy lazy = this.mongoClient$delegate;
        return (MongoClient)lazy.getValue();
    }

    @NotNull
    public final MongoDatabase getDatabase() {
        Lazy lazy = this.database$delegate;
        return (MongoDatabase)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <Result> Result runInTransaction(@NotNull Function1<? super ClientSession, ? extends Result> block) {
        void var3_3;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try (ClientSession session = MongoClient.startSession$default((MongoClient)this.getMongoClient$invirt_mongodb(), null, (int)1, null);){
            TransactionOptions transactionOptions = TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build();
            Intrinsics.checkNotNullExpressionValue((Object)transactionOptions, (String)"build(...)");
            session.startTransaction(transactionOptions);
            Object result = block.invoke((Object)session);
            session.commitTransaction();
        }
        return var3_3;
    }

    private static final MongoClient mongoClient_delegate$lambda$0(Mongo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return MongoClient.Factory.create(this$0.connectionString);
    }

    private static final Object database_delegate$lambda$2$lambda$1(Mongo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Successfully pinged MongoDB database '" + this$0.databaseName + "'";
    }

    private static final MongoDatabase database_delegate$lambda$2(Mongo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MongoDatabase db = this$0.getMongoClient$invirt_mongodb().getDatabase(this$0.databaseName);
        MongoDatabase.runCommand$default((MongoDatabase)db, (Bson)((Bson)new Document("ping", (Object)new BsonInt64(1L))), null, (int)2, null);
        MongoKt.access$getLog$p().info(() -> Mongo.database_delegate$lambda$2$lambda$1(this$0));
        return db;
    }

    private static final Object _init_$lambda$3(Mongo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CharSequence charSequence = this$0.connectionString;
        Regex regex = new Regex("://.*@");
        String string = "://*****@";
        return "MongoDB connection string: " + regex.replace(charSequence, string);
    }

    private static final Object runInTransaction$lambda$4(Throwable $e) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        return "MongoDB transaction error: " + $e.getMessage();
    }
}

