/*
 * Decompiled with CFR 0.152.
 */
package invirt.data.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.kotlin.client.MongoClient;
import com.mongodb.kotlin.client.MongoCollection;
import com.mongodb.kotlin.client.MongoDatabase;
import invirt.data.mongodb.CollectionName;
import invirt.data.mongodb.IndexKt;
import invirt.data.mongodb.MongoEntity;
import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.text.Regex;
import org.bson.BsonInt64;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\fH\u0086\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Linvirt/data/mongodb/MongoDb;", "", "connectionString", "", "(Ljava/lang/String;)V", "database", "Lcom/mongodb/kotlin/client/MongoDatabase;", "getDatabase", "()Lcom/mongodb/kotlin/client/MongoDatabase;", "getCollection", "Lcom/mongodb/kotlin/client/MongoCollection;", "T", "Linvirt/data/mongodb/MongoEntity;", "Companion", "invirt-mongodb"})
@SourceDebugExtension(value={"SMAP\nMongoDb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDb.kt\ninvirt/data/mongodb/MongoDb\n+ 2 MongoEntity.kt\ninvirt/data/mongodb/MongoEntityKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MongoDatabase.kt\ncom/mongodb/kotlin/client/MongoDatabase\n*L\n1#1,36:1\n28#2:37\n29#2,2:41\n20#3:38\n288#4,2:39\n118#5:43\n*S KotlinDebug\n*F\n+ 1 MongoDb.kt\ninvirt/data/mongodb/MongoDb\n*L\n27#1:37\n27#1:41,2\n27#1:38\n27#1:39,2\n27#1:43\n*E\n"})
public final class MongoDb {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoDatabase database;
    private static final Logger log = LoggerFactory.getLogger(MongoDb.class);

    public MongoDb(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        CharSequence charSequence = connectionString;
        Regex regex = new Regex("://.*@");
        String string = "://*****@";
        log.info("MongoDB connection string: " + regex.replace(charSequence, string));
        MongoClient client = MongoClient.Factory.create(connectionString);
        ConnectionString connection = new ConnectionString(connectionString);
        String string2 = connection.getDatabase();
        Intrinsics.checkNotNull((Object)string2);
        String databaseName = string2;
        this.database = client.getDatabase(databaseName);
        MongoDatabase.runCommand$default((MongoDatabase)this.database, (Bson)((Bson)new Document("ping", (Object)new BsonInt64(1L))), null, (int)2, null);
        List list = connection.getHosts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHosts(...)");
        log.info("Successfully pinged MongoDB database '" + databaseName + "' at '" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "'    ");
    }

    @NotNull
    public final MongoDatabase getDatabase() {
        return this.database;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends MongoEntity> MongoCollection<T> getCollection() {
        void collectionName$iv;
        void this_$iv;
        Object v0;
        block2: {
            boolean $i$f$getCollection = false;
            MongoDatabase mongoDatabase = this.getDatabase();
            boolean $i$f$collectionName = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KAnnotatedElement $this$findAnnotation$iv$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(MongoEntity.class);
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                boolean bl = false;
                if (!(it$iv$iv instanceof CollectionName)) continue;
                v0 = element$iv$iv$iv;
                break block2;
            }
            v0 = null;
        }
        CollectionName collectionName = (CollectionName)((Annotation)v0);
        if (collectionName == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException("Class " + Reflection.getOrCreateKotlinClass(MongoEntity.class) + " doesn't have an @CollectionName annotation");
        }
        CollectionName annotation$iv = collectionName;
        String $i$f$collectionName = annotation$iv.name();
        boolean $i$f$getCollection = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        MongoCollection collection = this_$iv.getCollection((String)collectionName$iv, Object.class);
        IndexKt.createIndexes(collection);
        return collection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Linvirt/data/mongodb/MongoDb$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "invirt-mongodb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

