package invirt.data.mongodb

import com.mongodb.ConnectionString
import com.mongodb.kotlin.client.MongoClient
import com.mongodb.kotlin.client.MongoCollection
import com.mongodb.kotlin.client.MongoDatabase
import org.bson.BsonInt64
import org.bson.Document
import org.slf4j.LoggerFactory

class MongoDb(connectionString: String) {

    val database: MongoDatabase

    init {
        log.info("MongoDB connection string: ${connectionString.replace("://.*@".toRegex(), "://*****@")}")
        val client = MongoClient.create(connectionString)
        val connection = ConnectionString(connectionString)
        val databaseName = connection.database!!

        database = client.getDatabase(databaseName)
        database.runCommand(Document("ping", BsonInt64(1)))
        log.info("Successfully pinged MongoDB database '${databaseName}' at '${connection.hosts.joinToString(", ")}'    ")
    }

    inline fun <reified T : MongoEntity> getCollection(): MongoCollection<T> {
        val collection = database.getCollection<T>(collectionName<T>())
        collection.createIndexes()
        return collection
    }

    companion object {
        private val log = LoggerFactory.getLogger(MongoDb::class.java)
    }
}
