/*
 * Decompiled with CFR 0.152.
 */
package io.really.jwt;

import io.really.jwt.JWTException;
import io.really.jwt.package;
import io.really.jwt.package$Algorithm$HS256$;
import io.really.jwt.package$Algorithm$HS384$;
import io.really.jwt.package$Algorithm$HS512$;
import io.really.jwt.package$Algorithm$RS256$;
import io.really.jwt.package$Algorithm$RS384$;
import io.really.jwt.package$Algorithm$RS512$;
import io.really.jwt.package$AlgorithmFmt$;
import io.really.jwt.package$JWTResult$EmptyJWT$;
import io.really.jwt.package$JWTResult$InvalidHeader$;
import io.really.jwt.package$JWTResult$InvalidSignature$;
import io.really.jwt.package$JWTResult$NotEnoughSegments$;
import io.really.jwt.package$JWTResult$TooManySegments$;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.json.package$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class JWT$ {
    public static final JWT$ MODULE$;

    static {
        new JWT$();
    }

    public String signToken(package.Algorithm algorithm, String msg, String key) {
        boolean bl;
        boolean bl2;
        package.Algorithm algorithm2 = algorithm;
        package$Algorithm$HS256$ package$Algorithm$HS256$2 = package$Algorithm$HS256$.MODULE$;
        package.Algorithm algorithm3 = algorithm2;
        if (!(package$Algorithm$HS256$2 != null ? !package$Algorithm$HS256$2.equals(algorithm3) : algorithm3 != null)) {
            bl2 = true;
        } else {
            package$Algorithm$HS384$ package$Algorithm$HS384$2 = package$Algorithm$HS384$.MODULE$;
            package.Algorithm algorithm4 = algorithm2;
            if (!(package$Algorithm$HS384$2 != null ? !package$Algorithm$HS384$2.equals(algorithm4) : algorithm4 != null)) {
                bl2 = true;
            } else {
                package$Algorithm$HS512$ package$Algorithm$HS512$2 = package$Algorithm$HS512$.MODULE$;
                package.Algorithm algorithm5 = algorithm2;
                bl2 = !(package$Algorithm$HS512$2 != null ? !package$Algorithm$HS512$2.equals(algorithm5) : algorithm5 != null);
            }
        }
        if (bl2) {
            String string = this.signHmac(algorithm, msg, key);
            return string;
        }
        package$Algorithm$RS256$ package$Algorithm$RS256$2 = package$Algorithm$RS256$.MODULE$;
        package.Algorithm algorithm6 = algorithm2;
        if (!(package$Algorithm$RS256$2 != null ? !package$Algorithm$RS256$2.equals(algorithm6) : algorithm6 != null)) {
            bl = true;
        } else {
            package$Algorithm$RS384$ package$Algorithm$RS384$2 = package$Algorithm$RS384$.MODULE$;
            package.Algorithm algorithm7 = algorithm2;
            if (!(package$Algorithm$RS384$2 != null ? !package$Algorithm$RS384$2.equals(algorithm7) : algorithm7 != null)) {
                bl = true;
            } else {
                package$Algorithm$RS512$ package$Algorithm$RS512$2 = package$Algorithm$RS512$.MODULE$;
                package.Algorithm algorithm8 = algorithm2;
                bl = !(package$Algorithm$RS512$2 != null ? !package$Algorithm$RS512$2.equals(algorithm8) : algorithm8 != null);
            }
        }
        if (bl) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)algorithm2);
    }

    public String signHmac(package.Algorithm algorithm, String msg, String key) {
        Mac mac = Mac.getInstance(algorithm.toString());
        mac.init(new SecretKeySpec(key.getBytes("utf-8"), algorithm.toString()));
        return new String(mac.doFinal(msg.getBytes("utf-8")));
    }

    public String encodeBase64url(String str) {
        return Base64.encodeBase64URLSafeString((byte[])str.getBytes("utf-8"));
    }

    public String decodeBase64url(String str) {
        return new String(Base64.decodeBase64((String)str));
    }

    public String encodeHeader(Option<package.Algorithm> algorithm, JsObject header) {
        Option<package.Algorithm> option;
        block4: {
            JsObject jsObject;
            block3: {
                block2: {
                    option = algorithm;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    package.Algorithm alg = (package.Algorithm)some.x();
                    jsObject = Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"alg"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)alg.toString(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"typ"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"JWT", (Writes)Writes$.MODULE$.StringWrites()))})).$plus$plus(header);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<package.Algorithm> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                jsObject = Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"typ"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"JWT", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"alg"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"", (Writes)Writes$.MODULE$.StringWrites()))})).$plus$plus(header);
            }
            JsObject h = jsObject;
            return this.encodeBase64url(Json$.MODULE$.stringify((JsValue)h));
        }
        throw new MatchError(option);
    }

    public String encodePayload(JsObject payload) {
        return this.encodeBase64url(Json$.MODULE$.stringify((JsValue)payload));
    }

    public String encodedSignature(String msg, String key, Option<package.Algorithm> algorithm) {
        Option<package.Algorithm> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = algorithm;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    package.Algorithm alg = (package.Algorithm)some.x();
                    string = this.encodeBase64url(this.signToken(alg, msg, key));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<package.Algorithm> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                string = "";
            }
            return string;
        }
        throw new MatchError(option);
    }

    public String encode(String secret, JsObject payload, JsObject header, Option<package.Algorithm> algorithm) {
        String headerEncoded = this.encodeHeader(algorithm, header);
        String payloadEncoded = this.encodePayload(payload);
        String signature = this.encodedSignature(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{headerEncoded, payloadEncoded})), secret, algorithm);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{headerEncoded, payloadEncoded, signature}));
    }

    public JsObject encode$default$3() {
        return Json$.MODULE$.obj((Seq)Nil$.MODULE$);
    }

    public Option<package.Algorithm> encode$default$4() {
        return new Some((Object)package$Algorithm$HS256$.MODULE$);
    }

    public Try<List<String>> partitionJwt(String str, boolean verify) {
        List parts = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split('.')).toList();
        return verify && parts.size() == 3 || !verify && List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).contains((Object)BoxesRunTime.boxToInteger((int)parts.size())) ? new Success((Object)parts) : (verify && parts.size() < 3 ? new Failure((Throwable)new JWTException.NotEnoughSegments()) : new Failure((Throwable)new JWTException.TooManySegments()));
    }

    public Try<Tuple4<JsObject, JsObject, String, String>> decodeParts(String jwt, boolean verify) {
        Try<List<String>> try_;
        block5: {
            Failure failure;
            block4: {
                block2: {
                    List list;
                    block3: {
                        Tuple3 tuple3;
                        try_ = this.partitionJwt(jwt, verify);
                        if (!(try_ instanceof Success)) break block2;
                        Success success = (Success)try_;
                        List parts = (List)success.value();
                        list = parts;
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        String headerPart = (String)colon2.hd$1();
                        List list2 = colon2.tl$1();
                        if (!(list2 instanceof .colon.colon)) break block3;
                        .colon.colon colon3 = (.colon.colon)list2;
                        String payloadPart = (String)colon3.hd$1();
                        List signaturePart = colon3.tl$1();
                        Tuple3 tuple32 = tuple3 = new Tuple3((Object)headerPart, (Object)payloadPart, (Object)signaturePart);
                        String headerPart2 = (String)tuple32._1();
                        String payloadPart2 = (String)tuple32._2();
                        List signaturePart2 = (List)tuple32._3();
                        JsObject header = (JsObject)Json$.MODULE$.parse(this.decodeBase64url(headerPart2)).as((Reads)Reads$.MODULE$.JsObjectReads());
                        JsObject payload = (JsObject)Json$.MODULE$.parse(this.decodeBase64url(payloadPart2)).as((Reads)Reads$.MODULE$.JsObjectReads());
                        String signature = (String)signaturePart2.head();
                        String signingInput = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{headerPart2, payloadPart2}));
                        failure = new Success((Object)new Tuple4((Object)header, (Object)payload, (Object)signature, (Object)signingInput));
                        break block4;
                    }
                    throw new MatchError((Object)list);
                }
                if (!(try_ instanceof Failure)) break block5;
                Failure failure2 = (Failure)try_;
                Throwable e = failure2.exception();
                failure = new Failure(e);
            }
            return failure;
        }
        throw new MatchError(try_);
    }

    public boolean verifySignature(package.Algorithm algorithm, String key, String signingInput, String signature) {
        boolean bl;
        boolean bl2;
        package.Algorithm algorithm2 = algorithm;
        package$Algorithm$HS256$ package$Algorithm$HS256$2 = package$Algorithm$HS256$.MODULE$;
        package.Algorithm algorithm3 = algorithm2;
        if (!(package$Algorithm$HS256$2 != null ? !package$Algorithm$HS256$2.equals(algorithm3) : algorithm3 != null)) {
            bl2 = true;
        } else {
            package$Algorithm$HS384$ package$Algorithm$HS384$2 = package$Algorithm$HS384$.MODULE$;
            package.Algorithm algorithm4 = algorithm2;
            if (!(package$Algorithm$HS384$2 != null ? !package$Algorithm$HS384$2.equals(algorithm4) : algorithm4 != null)) {
                bl2 = true;
            } else {
                package$Algorithm$HS512$ package$Algorithm$HS512$2 = package$Algorithm$HS512$.MODULE$;
                package.Algorithm algorithm5 = algorithm2;
                bl2 = !(package$Algorithm$HS512$2 != null ? !package$Algorithm$HS512$2.equals(algorithm5) : algorithm5 != null);
            }
        }
        if (bl2) {
            boolean bl3 = this.encodedSignature(signingInput, key, (Option<package.Algorithm>)new Some((Object)algorithm)).equals(signature);
            return bl3;
        }
        package$Algorithm$RS256$ package$Algorithm$RS256$2 = package$Algorithm$RS256$.MODULE$;
        package.Algorithm algorithm6 = algorithm2;
        if (!(package$Algorithm$RS256$2 != null ? !package$Algorithm$RS256$2.equals(algorithm6) : algorithm6 != null)) {
            bl = true;
        } else {
            package$Algorithm$RS384$ package$Algorithm$RS384$2 = package$Algorithm$RS384$.MODULE$;
            package.Algorithm algorithm7 = algorithm2;
            if (!(package$Algorithm$RS384$2 != null ? !package$Algorithm$RS384$2.equals(algorithm7) : algorithm7 != null)) {
                bl = true;
            } else {
                package$Algorithm$RS512$ package$Algorithm$RS512$2 = package$Algorithm$RS512$.MODULE$;
                package.Algorithm algorithm8 = algorithm2;
                bl = !(package$Algorithm$RS512$2 != null ? !package$Algorithm$RS512$2.equals(algorithm8) : algorithm8 != null);
            }
        }
        if (bl) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)algorithm2);
    }

    public Option<package.JWTHeader> validateJWTHeader(JsObject obj) {
        JsResult jsResult;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    Reads algRead = package$.MODULE$.__().$bslash("alg").read((Reads)package$AlgorithmFmt$.MODULE$);
                    jsResult = obj.validate(algRead);
                    if (!(jsResult instanceof JsSuccess)) break block2;
                    JsSuccess jsSuccess = (JsSuccess)jsResult;
                    package.Algorithm alg = (package.Algorithm)jsSuccess.value();
                    none$ = new Some((Object)new package.JWTHeader(alg, obj.$minus("alg").$minus("typ")));
                    break block3;
                }
                if (!(jsResult instanceof JsError)) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)jsResult);
    }

    public package.JWTResult decode(String jwt, Option<String> key) {
        Try<Tuple4<JsObject, JsObject, String, String>> try_;
        Failure failure;
        boolean bl;
        block14: {
            Product product;
            block5: {
                Product product2;
                block12: {
                    Throwable e;
                    block13: {
                        block6: {
                            Option<package.JWTHeader> option;
                            block11: {
                                Product product3;
                                block8: {
                                    block10: {
                                        Some some;
                                        boolean bl2;
                                        JsObject payload;
                                        block9: {
                                            block7: {
                                                Success success;
                                                Tuple4 tuple4;
                                                block4: {
                                                    if (!jwt.trim().isEmpty()) break block4;
                                                    product = package$JWTResult$EmptyJWT$.MODULE$;
                                                    break block5;
                                                }
                                                bl = false;
                                                failure = null;
                                                try_ = this.decodeParts(jwt, key.isDefined());
                                                if (!(try_ instanceof Success) || (tuple4 = (Tuple4)(success = (Success)try_).value()) == null) break block6;
                                                JsObject headerJs = (JsObject)tuple4._1();
                                                payload = (JsObject)tuple4._2();
                                                String signature = (String)tuple4._3();
                                                String signingInput = (String)tuple4._4();
                                                bl2 = false;
                                                some = null;
                                                option = this.validateJWTHeader(headerJs);
                                                if (!(option instanceof Some)) break block7;
                                                bl2 = true;
                                                some = (Some)option;
                                                package.JWTHeader header = (package.JWTHeader)some.x();
                                                if (!key.isDefined() || !this.verifySignature(header.alg(), (String)key.get(), signingInput, signature)) break block7;
                                                product3 = new package.JWTResult.JWT(header, payload);
                                                break block8;
                                            }
                                            if (!bl2 || !key.isDefined()) break block9;
                                            product3 = package$JWTResult$InvalidSignature$.MODULE$;
                                            break block8;
                                        }
                                        if (!bl2) break block10;
                                        package.JWTHeader header = (package.JWTHeader)some.x();
                                        product3 = new package.JWTResult.JWT(header, payload);
                                        break block8;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<package.JWTHeader> option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block11;
                                    product3 = package$JWTResult$InvalidHeader$.MODULE$;
                                }
                                product2 = product3;
                                break block12;
                            }
                            throw new MatchError(option);
                        }
                        if (!(try_ instanceof Failure)) break block13;
                        bl = true;
                        failure = (Failure)try_;
                        Throwable e2 = failure.exception();
                        if (!(e2 instanceof JWTException.NotEnoughSegments)) break block13;
                        product2 = package$JWTResult$NotEnoughSegments$.MODULE$;
                        break block12;
                    }
                    if (!bl || !((e = failure.exception()) instanceof JWTException.TooManySegments)) break block14;
                    product2 = package$JWTResult$TooManySegments$.MODULE$;
                }
                product = product2;
            }
            return product;
        }
        if (bl) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError(try_);
    }

    private JWT$() {
        MODULE$ = this;
    }
}

