/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.WorkloadParams;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.Utils;

public class BenchmarkListEntry
implements Comparable<BenchmarkListEntry> {
    private static final String BR_SEPARATOR = "===,===";
    private final String userClassQName;
    private final String generatedClassQName;
    private final String method;
    private final Mode mode;
    private final int[] threadGroups;
    private final Optional<Integer> threads;
    private final Optional<Integer> warmupIterations;
    private final Optional<TimeValue> warmupTime;
    private final Optional<Integer> warmupBatchSize;
    private final Optional<Integer> measurementIterations;
    private final Optional<TimeValue> measurementTime;
    private final Optional<Integer> measurementBatchSize;
    private final Optional<Integer> forks;
    private final Optional<Integer> warmupForks;
    private final Optional<String> jvm;
    private final Optional<Collection<String>> jvmArgs;
    private final Optional<Collection<String>> jvmArgsPrepend;
    private final Optional<Collection<String>> jvmArgsAppend;
    private final Optional<Map<String, String[]>> params;
    private final Optional<TimeUnit> tu;
    private final Optional<Integer> opsPerInvocation;
    private final Optional<TimeValue> timeout;
    private WorkloadParams workloadParams;
    static final Optional.Unmarshaller<Integer> INTEGER_UNMARSHALLER = new Optional.Unmarshaller<Integer>(){

        @Override
        public Integer valueOf(String s) {
            return Integer.valueOf(s);
        }
    };
    static final Optional.Unmarshaller<TimeValue> TIME_VALUE_UNMARSHALLER = new Optional.Unmarshaller<TimeValue>(){

        @Override
        public TimeValue valueOf(String s) {
            return TimeValue.fromString(s);
        }
    };
    static final Optional.Unmarshaller<TimeUnit> TIMEUNIT_UNMARSHALLER = new Optional.Unmarshaller<TimeUnit>(){

        @Override
        public TimeUnit valueOf(String s) {
            return TimeUnit.valueOf(s);
        }
    };
    static final Optional.Marshaller<TimeUnit> TIMEUNIT_MARSHALLER = new Optional.Marshaller<TimeUnit>(){

        @Override
        public String valueOf(TimeUnit val) {
            return val.toString();
        }
    };
    static final Optional.Unmarshaller<String> STRING_UNMARSHALLER = new Optional.Unmarshaller<String>(){

        @Override
        public String valueOf(String s) {
            return s;
        }
    };
    static final Optional.Marshaller<String> STRING_MARSHALLER = new Optional.Marshaller<String>(){

        @Override
        public String valueOf(String s) {
            return s;
        }
    };
    static final Optional.Unmarshaller<Collection<String>> STRING_COLLECTION_UNMARSHALLER = new Optional.Unmarshaller<Collection<String>>(){

        @Override
        public Collection<String> valueOf(String s) {
            return Arrays.asList(s.split("===SEP==="));
        }
    };
    static final Optional.Marshaller<Collection<String>> STRING_COLLECTION_MARSHALLER = new Optional.Marshaller<Collection<String>>(){

        @Override
        public String valueOf(Collection<String> src) {
            StringBuilder sb = new StringBuilder();
            for (String s : src) {
                sb.append(s).append("===SEP===");
            }
            return sb.toString();
        }
    };
    static final Optional.Unmarshaller<Map<String, String[]>> PARAM_COLLECTION_UNMARSHALLER = new Optional.Unmarshaller<Map<String, String[]>>(){

        @Override
        public Map<String, String[]> valueOf(String s) {
            String[] pairs;
            TreeMap<String, String[]> map = new TreeMap<String, String[]>();
            for (String pair : pairs = s.split("===PAIR-SEP===")) {
                String[] kv = pair.split("===SEP-K===");
                if (kv[1].equalsIgnoreCase("===EMPTY===")) {
                    map.put(kv[0], new String[0]);
                    continue;
                }
                String[] vals = kv[1].split("===SEP-V===");
                for (int c = 0; c < vals.length; ++c) {
                    if (!vals[c].equals("===EMPTY-VAL===")) continue;
                    vals[c] = "";
                }
                map.put(kv[0], vals);
            }
            return map;
        }
    };
    static final Optional.Marshaller<Map<String, String[]>> PARAM_COLLECTION_MARSHALLER = new Optional.Marshaller<Map<String, String[]>>(){

        @Override
        public String valueOf(Map<String, String[]> src) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String[]> e : src.entrySet()) {
                sb.append(e.getKey());
                sb.append("===SEP-K===");
                if (e.getValue().length == 0) {
                    sb.append("===EMPTY===");
                } else {
                    for (String v : e.getValue()) {
                        if (v.isEmpty()) {
                            sb.append("===EMPTY-VAL===");
                        } else {
                            sb.append(v);
                        }
                        sb.append("===SEP-V===");
                    }
                }
                sb.append("===PAIR-SEP===");
            }
            return sb.toString();
        }
    };

    public BenchmarkListEntry(String userClassQName, String generatedClassQName, String method, Mode mode, int[] threadGroups, Optional<Integer> threads, Optional<Integer> warmupIterations, Optional<TimeValue> warmupTime, Optional<Integer> warmupBatchSize, Optional<Integer> measurementIterations, Optional<TimeValue> measurementTime, Optional<Integer> measurementBatchSize, Optional<Integer> forks, Optional<Integer> warmupForks, Optional<String> jvm, Optional<Collection<String>> jvmArgs, Optional<Collection<String>> jvmArgsPrepend, Optional<Collection<String>> jvmArgsAppend, Optional<Map<String, String[]>> params, Optional<TimeUnit> tu, Optional<Integer> opsPerInv, Optional<TimeValue> timeout) {
        this.userClassQName = userClassQName;
        this.generatedClassQName = generatedClassQName;
        this.method = method;
        this.mode = mode;
        this.threadGroups = threadGroups;
        this.threads = threads;
        this.warmupIterations = warmupIterations;
        this.warmupTime = warmupTime;
        this.warmupBatchSize = warmupBatchSize;
        this.measurementIterations = measurementIterations;
        this.measurementTime = measurementTime;
        this.measurementBatchSize = measurementBatchSize;
        this.forks = forks;
        this.warmupForks = warmupForks;
        this.jvm = jvm;
        this.jvmArgs = jvmArgs;
        this.jvmArgsPrepend = jvmArgsPrepend;
        this.jvmArgsAppend = jvmArgsAppend;
        this.params = params;
        this.workloadParams = new WorkloadParams();
        this.tu = tu;
        this.opsPerInvocation = opsPerInv;
        this.timeout = timeout;
    }

    public BenchmarkListEntry(String line) {
        String[] args = line.split(BR_SEPARATOR);
        if (args.length != 22) {
            throw new IllegalStateException("Mismatched format for the line: " + line);
        }
        this.workloadParams = new WorkloadParams();
        int idx = 0;
        this.userClassQName = args[idx++].trim();
        this.generatedClassQName = args[idx++].trim();
        this.method = args[idx++].trim();
        this.mode = Mode.deepValueOf(args[idx++].trim());
        this.threadGroups = Utils.unmarshalIntArray(args[idx++]);
        this.threads = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.warmupIterations = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.warmupTime = Optional.of(args[idx++], TIME_VALUE_UNMARSHALLER);
        this.warmupBatchSize = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.measurementIterations = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.measurementTime = Optional.of(args[idx++], TIME_VALUE_UNMARSHALLER);
        this.measurementBatchSize = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.forks = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.warmupForks = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.jvm = Optional.of(args[idx++], STRING_UNMARSHALLER);
        this.jvmArgs = Optional.of(args[idx++], STRING_COLLECTION_UNMARSHALLER);
        this.jvmArgsPrepend = Optional.of(args[idx++], STRING_COLLECTION_UNMARSHALLER);
        this.jvmArgsAppend = Optional.of(args[idx++], STRING_COLLECTION_UNMARSHALLER);
        this.params = Optional.of(args[idx++], PARAM_COLLECTION_UNMARSHALLER);
        this.tu = Optional.of(args[idx++], TIMEUNIT_UNMARSHALLER);
        this.opsPerInvocation = Optional.of(args[idx++], INTEGER_UNMARSHALLER);
        this.timeout = Optional.of(args[idx++], TIME_VALUE_UNMARSHALLER);
    }

    public BenchmarkListEntry(String userClassQName, String generatedName, String method, Mode mode) {
        this(userClassQName, generatedName, method, mode, new int[0], Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none(), Optional.none());
    }

    public String toLine() {
        return this.userClassQName + BR_SEPARATOR + this.generatedClassQName + BR_SEPARATOR + this.method + BR_SEPARATOR + (Object)((Object)this.mode) + BR_SEPARATOR + Utils.marshalIntArray(this.threadGroups) + BR_SEPARATOR + this.threads + BR_SEPARATOR + this.warmupIterations + BR_SEPARATOR + this.warmupTime + BR_SEPARATOR + this.warmupBatchSize + BR_SEPARATOR + this.measurementIterations + BR_SEPARATOR + this.measurementTime + BR_SEPARATOR + this.measurementBatchSize + BR_SEPARATOR + this.forks + BR_SEPARATOR + this.warmupForks + BR_SEPARATOR + this.jvm.toString(STRING_MARSHALLER) + BR_SEPARATOR + this.jvmArgs.toString(STRING_COLLECTION_MARSHALLER) + BR_SEPARATOR + this.jvmArgsPrepend.toString(STRING_COLLECTION_MARSHALLER) + BR_SEPARATOR + this.jvmArgsAppend.toString(STRING_COLLECTION_MARSHALLER) + BR_SEPARATOR + this.params.toString(PARAM_COLLECTION_MARSHALLER) + BR_SEPARATOR + this.tu.toString(TIMEUNIT_MARSHALLER) + BR_SEPARATOR + this.opsPerInvocation + BR_SEPARATOR + this.timeout;
    }

    public BenchmarkListEntry cloneWith(Mode mode) {
        return new BenchmarkListEntry(this.userClassQName, this.generatedClassQName, this.method, mode, this.threadGroups, this.threads, this.warmupIterations, this.warmupTime, this.warmupBatchSize, this.measurementIterations, this.measurementTime, this.measurementBatchSize, this.forks, this.warmupForks, this.jvm, this.jvmArgs, this.jvmArgsPrepend, this.jvmArgsAppend, this.params, this.tu, this.opsPerInvocation, this.timeout);
    }

    public BenchmarkListEntry cloneWith(WorkloadParams p) {
        BenchmarkListEntry br = new BenchmarkListEntry(this.userClassQName, this.generatedClassQName, this.method, this.mode, this.threadGroups, this.threads, this.warmupIterations, this.warmupTime, this.warmupBatchSize, this.measurementIterations, this.measurementTime, this.measurementBatchSize, this.forks, this.warmupForks, this.jvm, this.jvmArgs, this.jvmArgsPrepend, this.jvmArgsAppend, this.params, this.tu, this.opsPerInvocation, this.timeout);
        br.workloadParams = p;
        return br;
    }

    public WorkloadParams getWorkloadParams() {
        return this.workloadParams;
    }

    @Override
    public int compareTo(BenchmarkListEntry o) {
        int v = this.mode.compareTo(o.mode);
        if (v != 0) {
            return v;
        }
        int v1 = this.getUsername().compareTo(o.getUsername());
        if (v1 != 0) {
            return v1;
        }
        if (this.workloadParams == null || o.workloadParams == null) {
            return 0;
        }
        return this.workloadParams.compareTo(o.workloadParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BenchmarkListEntry record = (BenchmarkListEntry)o;
        if (this.mode != record.mode) {
            return false;
        }
        if (this.workloadParams != null ? !this.workloadParams.equals(record.workloadParams) : record.workloadParams != null) {
            return false;
        }
        if (this.userClassQName != null ? !this.userClassQName.equals(record.userClassQName) : record.userClassQName != null) {
            return false;
        }
        return !(this.method != null ? !this.method.equals(record.method) : record.method != null);
    }

    public int hashCode() {
        int result = this.userClassQName != null ? this.userClassQName.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + (this.workloadParams != null ? this.workloadParams.hashCode() : 0);
        return result;
    }

    public String generatedTarget() {
        return this.generatedClassQName + "." + this.method + "_" + (Object)((Object)this.mode);
    }

    public String getUsername() {
        return this.userClassQName + "." + this.method;
    }

    public String getUserClassQName() {
        return this.userClassQName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int[] getThreadGroups() {
        return Arrays.copyOf(this.threadGroups, this.threadGroups.length);
    }

    public String toString() {
        return "{'" + this.userClassQName + "." + this.method + "', " + (Object)((Object)this.mode) + ", " + this.workloadParams + "}";
    }

    public Optional<TimeValue> getWarmupTime() {
        return this.warmupTime;
    }

    public Optional<Integer> getWarmupIterations() {
        return this.warmupIterations;
    }

    public Optional<Integer> getWarmupBatchSize() {
        return this.warmupBatchSize;
    }

    public Optional<TimeValue> getMeasurementTime() {
        return this.measurementTime;
    }

    public Optional<Integer> getMeasurementIterations() {
        return this.measurementIterations;
    }

    public Optional<Integer> getMeasurementBatchSize() {
        return this.measurementBatchSize;
    }

    public Optional<Integer> getForks() {
        return this.forks;
    }

    public Optional<Integer> getWarmupForks() {
        return this.warmupForks;
    }

    public Optional<String> getJvm() {
        return this.jvm;
    }

    public Optional<Collection<String>> getJvmArgs() {
        return this.jvmArgs;
    }

    public Optional<Collection<String>> getJvmArgsAppend() {
        return this.jvmArgsAppend;
    }

    public Optional<Collection<String>> getJvmArgsPrepend() {
        return this.jvmArgsPrepend;
    }

    public Optional<Integer> getThreads() {
        return this.threads;
    }

    public Optional<Map<String, String[]>> getParams() {
        return this.params;
    }

    public Optional<TimeUnit> getTimeUnit() {
        return this.tu;
    }

    public Optional<Integer> getOperationsPerInvocation() {
        return this.opsPerInvocation;
    }

    public Optional<TimeValue> getTimeout() {
        return this.timeout;
    }
}

