/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Multiset;

public class GCProfiler
implements InternalProfiler {
    private long beforeTime;
    private long beforeGCCount;
    private long beforeGCTime;
    private HotspotAllocationSnapshot beforeAllocated;
    private final NotificationListener listener;
    private volatile Multiset<String> churn = new HashMultiset<String>();
    private boolean hooksInstalled;

    public GCProfiler() throws ProfilerException {
        NotificationListener listener;
        try {
            Class<?> infoKlass = Class.forName("com.sun.management.GarbageCollectionNotificationInfo");
            final Field notifNameField = infoKlass.getField("GARBAGE_COLLECTION_NOTIFICATION");
            final Method infoMethod = infoKlass.getMethod("from", CompositeData.class);
            final Method getGcInfo = infoKlass.getMethod("getGcInfo", new Class[0]);
            final Method getMemoryUsageBeforeGc = getGcInfo.getReturnType().getMethod("getMemoryUsageBeforeGc", new Class[0]);
            final Method getMemoryUsageAfterGc = getGcInfo.getReturnType().getMethod("getMemoryUsageAfterGc", new Class[0]);
            listener = new NotificationListener(){

                @Override
                public void handleNotification(Notification n, Object o) {
                    try {
                        if (n.getType().equals(notifNameField.get(null))) {
                            Object info = infoMethod.invoke(null, n.getUserData());
                            Object gcInfo = getGcInfo.invoke(info, new Object[0]);
                            Map mapBefore = (Map)getMemoryUsageBeforeGc.invoke(gcInfo, new Object[0]);
                            Map mapAfter = (Map)getMemoryUsageAfterGc.invoke(gcInfo, new Object[0]);
                            for (Map.Entry entry : mapAfter.entrySet()) {
                                String name = (String)entry.getKey();
                                MemoryUsage after = (MemoryUsage)entry.getValue();
                                MemoryUsage before = (MemoryUsage)mapBefore.get(name);
                                long c = before.getUsed() - after.getUsed();
                                if (c <= 0L) continue;
                                GCProfiler.this.churn.add(name, c);
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (ClassNotFoundException e) {
            throw new ProfilerException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ProfilerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ProfilerException(e);
        }
        this.listener = listener;
    }

    @Override
    public String getDescription() {
        return "GC profiling via standard MBeans";
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.installHooks();
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        this.beforeGCCount = gcCount;
        this.beforeGCTime = gcTime;
        this.beforeAllocated = HotspotAllocationSnapshot.create();
        this.beforeTime = System.nanoTime();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iResult) {
        this.uninstallHooks();
        long afterTime = System.nanoTime();
        HotspotAllocationSnapshot newSnapshot = HotspotAllocationSnapshot.create();
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        ArrayList<ProfilerResult> results = new ArrayList<ProfilerResult>();
        if (this.beforeAllocated == HotspotAllocationSnapshot.EMPTY) {
            results.add(new ProfilerResult("\u00b7gc.alloc.rate", Double.NaN, "MB/sec", AggregationPolicy.AVG));
        } else {
            long allocated = newSnapshot.subtract(this.beforeAllocated);
            results.add(new ProfilerResult("\u00b7gc.alloc.rate", afterTime != this.beforeTime ? 1.0 * (double)allocated / 1024.0 / 1024.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(afterTime - this.beforeTime) : Double.NaN, "MB/sec", AggregationPolicy.AVG));
            if (allocated != 0L) {
                long allOps = iResult.getMetadata().getAllOps();
                results.add(new ProfilerResult("\u00b7gc.alloc.rate.norm", allOps != 0L ? 1.0 * (double)allocated / (double)allOps : Double.NaN, "B/op", AggregationPolicy.AVG));
            }
        }
        results.add(new ProfilerResult("\u00b7gc.count", gcCount - this.beforeGCCount, "counts", AggregationPolicy.SUM));
        if (gcCount != this.beforeGCCount || gcTime != this.beforeGCTime) {
            results.add(new ProfilerResult("\u00b7gc.time", gcTime - this.beforeGCTime, "ms", AggregationPolicy.SUM));
        }
        for (String space : this.churn.keys()) {
            double churnRate = afterTime != this.beforeTime ? 1.0 * (double)this.churn.count(space) * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(afterTime - this.beforeTime) / 1024.0 / 1024.0 : Double.NaN;
            double churnNorm = 1.0 * (double)this.churn.count(space) / (double)iResult.getMetadata().getAllOps();
            String spaceName = space.replaceAll(" ", "_");
            results.add(new ProfilerResult("\u00b7gc.churn." + spaceName + "", churnRate, "MB/sec", AggregationPolicy.AVG));
            results.add(new ProfilerResult("\u00b7gc.churn." + spaceName + ".norm", churnNorm, "B/op", AggregationPolicy.AVG));
        }
        return results;
    }

    public synchronized void installHooks() {
        if (this.hooksInstalled) {
            return;
        }
        this.hooksInstalled = true;
        this.churn = new HashMultiset<String>();
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ((NotificationEmitter)((Object)bean)).addNotificationListener(this.listener, null, null);
        }
    }

    public synchronized void uninstallHooks() {
        if (!this.hooksInstalled) {
            return;
        }
        this.hooksInstalled = false;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            try {
                ((NotificationEmitter)((Object)bean)).removeNotificationListener(this.listener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {}
        }
    }

    static class HotspotAllocationSnapshot {
        public static final HotspotAllocationSnapshot EMPTY = new HotspotAllocationSnapshot(new long[0], new long[0]);
        private static volatile Method GET_THREAD_ALLOCATED_BYTES;
        private static volatile boolean allocationNotAvailable;
        private final long[] threadIds;
        private final long[] allocatedBytes;

        private HotspotAllocationSnapshot(long[] threadIds, long[] allocatedBytes) {
            this.threadIds = threadIds;
            this.allocatedBytes = allocatedBytes;
        }

        public static HotspotAllocationSnapshot create() {
            Method getBytes = HotspotAllocationSnapshot.getAllocatedBytesGetter();
            if (getBytes == null) {
                return EMPTY;
            }
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            try {
                long[] threadIds = threadMXBean.getAllThreadIds();
                long[] allocatedBytes = (long[])getBytes.invoke((Object)threadMXBean, new Object[]{threadIds});
                return new HotspotAllocationSnapshot(threadIds, allocatedBytes);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return EMPTY;
        }

        public long subtract(HotspotAllocationSnapshot other) {
            HashMap<Long, Integer> prevIndex = new HashMap<Long, Integer>();
            for (int i = 0; i < other.threadIds.length; ++i) {
                long id = other.threadIds[i];
                prevIndex.put(id, i);
            }
            long currentThreadId = Thread.currentThread().getId();
            long allocated = 0L;
            for (int i = 0; i < this.threadIds.length; ++i) {
                long id = this.threadIds[i];
                if (id == currentThreadId) continue;
                allocated += this.allocatedBytes[i];
                Integer prev = (Integer)prevIndex.get(id);
                if (prev == null) continue;
                allocated -= other.allocatedBytes[prev];
            }
            return allocated;
        }

        private static Method getAllocatedBytesGetter() {
            Method getBytes = GET_THREAD_ALLOCATED_BYTES;
            if (getBytes != null || allocationNotAvailable) {
                return getBytes;
            }
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            try {
                getBytes = threadMXBean.getClass().getMethod("getThreadAllocatedBytes", long[].class);
                getBytes.setAccessible(true);
            }
            catch (Throwable e) {
                getBytes = null;
                allocationNotAvailable = true;
                System.out.println("Allocation profiling is not available: " + e.getMessage());
            }
            GET_THREAD_ALLOCATED_BYTES = getBytes;
            return getBytes;
        }
    }
}

