/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.HelperMethodInvocation;
import org.openjdk.jmh.generators.core.Identifiers;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;

class StateObject {
    public static final Comparator<StateObject> ID_COMPARATOR = new Comparator<StateObject>(){

        @Override
        public int compare(StateObject o1, StateObject o2) {
            return o1.fieldIdentifier.compareTo(o2.fieldIdentifier);
        }
    };
    public final String packageName;
    public final String userType;
    public final String type;
    public final Scope scope;
    public final String localIdentifier;
    public final String fieldIdentifier;
    public final Multimap<String, FieldInfo> params;
    public final SortedSet<HelperMethodInvocation> helpers;

    public StateObject(Identifiers identifiers, ClassInfo info, Scope scope) {
        this.packageName = info.getPackageName() + ".generated";
        this.userType = info.getQualifiedName();
        this.type = identifiers.getJMHtype(info);
        this.scope = scope;
        String id = identifiers.collapseTypeName(this.userType) + identifiers.identifier(scope);
        this.localIdentifier = "l_" + id;
        this.fieldIdentifier = "f_" + id;
        this.params = new TreeMultimap<String, FieldInfo>();
        this.helpers = new TreeSet<HelperMethodInvocation>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateObject that = (StateObject)o;
        if (!this.fieldIdentifier.equals(that.fieldIdentifier)) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + this.fieldIdentifier.hashCode();
        return result;
    }

    public String toTypeDef() {
        return this.type + " " + this.localIdentifier;
    }

    public String toLocal() {
        return this.localIdentifier;
    }

    public Collection<String> getParamsLabels() {
        return this.params.keys();
    }

    public void addParam(FieldInfo fieldInfo) {
        this.params.put(fieldInfo.getName(), fieldInfo);
    }

    public Collection<FieldInfo> getParam(String name) {
        return this.params.get(name);
    }

    public String getParamAccessor(FieldInfo paramField) {
        String name = paramField.getName();
        String type = paramField.getType().getQualifiedName();
        if (type.equalsIgnoreCase("java.lang.String")) {
            return "control.getParam(\"" + name + "\")";
        }
        if (type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("java.lang.Boolean")) {
            return "Boolean.valueOf(control.getParam(\"" + name + "\"))";
        }
        if (type.equalsIgnoreCase("byte") || type.equalsIgnoreCase("java.lang.Byte")) {
            return "Byte.valueOf(control.getParam(\"" + name + "\"))";
        }
        if (type.equalsIgnoreCase("char") || type.equalsIgnoreCase("java.lang.Character")) {
            return "(control.getParam(\"" + name + "\")).charAt(0)";
        }
        if (type.equalsIgnoreCase("short") || type.equalsIgnoreCase("java.lang.Short")) {
            return "Short.valueOf(control.getParam(\"" + name + "\"))";
        }
        if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("java.lang.Integer")) {
            return "Integer.valueOf(control.getParam(\"" + name + "\"))";
        }
        if (type.equalsIgnoreCase("float") || type.equalsIgnoreCase("java.lang.Float")) {
            return "Float.valueOf(control.getParam(\"" + name + "\"))";
        }
        if (type.equalsIgnoreCase("long") || type.equalsIgnoreCase("java.lang.Long")) {
            return "Long.valueOf(control.getParam(\"" + name + "\"))";
        }
        if (type.equalsIgnoreCase("double") || type.equalsIgnoreCase("java.lang.Double")) {
            return "Double.valueOf(control.getParam(\"" + name + "\"))";
        }
        return type + ".valueOf(control.getParam(\"" + name + "\"))";
    }

    public void addHelper(HelperMethodInvocation hmi) {
        this.helpers.add(hmi);
    }

    public Collection<HelperMethodInvocation> getHelpers() {
        return this.helpers;
    }
}

