/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.MetadataInfo;
import org.openjdk.jmh.util.Utils;

public class APGeneratorDestinaton
implements GeneratorDestination {
    private final RoundEnvironment roundEnv;
    private final ProcessingEnvironment processingEnv;

    public APGeneratorDestinaton(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        this.roundEnv = roundEnv;
        this.processingEnv = processingEnv;
    }

    @Override
    public Writer newResource(String resourcePath) throws IOException {
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", resourcePath, new Element[0]).openWriter();
    }

    @Override
    public Reader getResource(String resourcePath) throws IOException {
        return this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resourcePath).openReader(true);
    }

    @Override
    public Writer newClass(String className) throws IOException {
        return this.processingEnv.getFiler().createSourceFile(className, new Element[0]).openWriter();
    }

    @Override
    public void printError(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    @Override
    public void printError(String message, MetadataInfo element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, ((APMetadataInfo)((Object)element)).getElement());
    }

    @Override
    public void printError(String message, Throwable throwable) {
        this.printError(message + " " + Utils.throwableToString(throwable));
    }

    @Override
    public void printWarning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }

    @Override
    public void printWarning(String message, MetadataInfo element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, ((APMetadataInfo)((Object)element)).getElement());
    }

    @Override
    public void printWarning(String message, Throwable throwable) {
        this.printWarning(message + " " + Utils.throwableToString(throwable));
    }

    @Override
    public void printNote(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }
}

