/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.threads;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.annotations.Beta;
import rx.functions.Action0;
import rx.internal.schedulers.ScheduledAction;
import rx.internal.util.SubscriptionList;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

@Beta
public class RxJavaEventloopScheduler
extends Scheduler {
    private final EventLoopGroup eventLoopGroup;

    public RxJavaEventloopScheduler(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    @Override
    public Scheduler.Worker createWorker() {
        EventLoop eventLoop = this.eventLoopGroup.next();
        return new EventloopWorker(eventLoop);
    }

    static class EventloopWorker
    extends Scheduler.Worker {
        private final SubscriptionList serial;
        private final CompositeSubscription timed;
        private final SubscriptionList both;
        private final EventLoop eventLoop;

        public EventloopWorker(EventLoop eventLoop) {
            this.eventLoop = eventLoop;
            this.serial = new SubscriptionList();
            this.timed = new CompositeSubscription();
            this.both = new SubscriptionList(this.serial, this.timed);
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.DAYS);
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            ScheduledAction sa;
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            if (delayTime <= 0L) {
                sa = new ScheduledAction(action, this.serial);
                this.serial.add(sa);
            } else {
                sa = new ScheduledAction(action, this.timed);
                this.timed.add(sa);
            }
            final ScheduledFuture<?> result = this.eventLoop.schedule(sa, delayTime, unit);
            Subscription cancelFuture = Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    result.cancel(false);
                }
            });
            sa.add(cancelFuture);
            return sa;
        }

        @Override
        public void unsubscribe() {
            this.both.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.both.isUnsubscribed();
        }

        public boolean hasScheduledSubscriptions() {
            return this.serial.hasSubscriptions();
        }

        public boolean hasDelayScheduledSubscriptions() {
            return this.timed.hasSubscriptions();
        }
    }
}

