/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.reactivex.netty.channel.AllocatingTransformer;
import java.util.LinkedList;
import java.util.List;

public class WriteTransformations {
    private TransformerChain transformers;

    public boolean transform(Object msg, ByteBufAllocator allocator, List<Object> out) {
        boolean transformed = false;
        if (msg instanceof String) {
            out.add(allocator.buffer().writeBytes(((String)msg).getBytes()));
            transformed = true;
        } else if (msg instanceof byte[]) {
            out.add(allocator.buffer().writeBytes((byte[])msg));
            transformed = true;
        } else if (null != this.transformers && this.transformers.acceptMessage(msg)) {
            out.addAll(this.transformers.transform(msg, allocator));
            transformed = true;
        }
        return transformed;
    }

    public <T, TT> void appendTransformer(AllocatingTransformer<T, TT> transformer) {
        this.transformers = new TransformerChain(transformer, this.transformers);
    }

    public void resetTransformations() {
        this.transformers = null;
    }

    public boolean acceptMessage(Object msg) {
        return msg instanceof String || msg instanceof byte[] || null != this.transformers && this.transformers.acceptMessage(msg);
    }

    private static class TransformerChain
    extends AllocatingTransformer {
        private final AllocatingTransformer start;
        private final AllocatingTransformer next;

        public TransformerChain(AllocatingTransformer start, AllocatingTransformer next) {
            this.start = start;
            this.next = next;
        }

        public List transform(Object toTransform, ByteBufAllocator allocator) {
            if (null == this.next) {
                return this.start.transform(toTransform, allocator);
            }
            List transformed = this.start.transform(toTransform, allocator);
            if (transformed.size() == 1) {
                return this.next.transform(transformed.get(0), allocator);
            }
            LinkedList toReturn = new LinkedList();
            for (Object nextItem : transformed) {
                toReturn.addAll(this.next.transform(nextItem, allocator));
            }
            return toReturn;
        }

        @Override
        protected boolean acceptMessage(Object msg) {
            return this.start.acceptMessage(msg);
        }
    }
}

