/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MarkAwarePipeline
implements ChannelPipeline {
    private boolean marked;
    private final ChannelPipeline delegate;

    public MarkAwarePipeline(ChannelPipeline delegate) {
        this.delegate = delegate;
    }

    public synchronized MarkAwarePipeline mark() {
        if (this.marked) {
            throw new IllegalStateException("Pipeline does not support nested marks.");
        }
        return this;
    }

    public synchronized MarkAwarePipeline markIfNotYetMarked() {
        if (!this.marked) {
            return this.mark();
        }
        return this;
    }

    public synchronized MarkAwarePipeline reset() {
        if (!this.marked) {
            return this;
        }
        this.marked = false;
        return this;
    }

    public synchronized boolean isMarked() {
        return this.marked;
    }

    @Override
    public ChannelPipeline addFirst(String name, ChannelHandler handler) {
        this.delegate.addFirst(name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addFirst(EventExecutorGroup group, String name, ChannelHandler handler) {
        this.delegate.addFirst(group, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addFirst(ChannelHandlerInvoker invoker, String name, ChannelHandler handler) {
        this.delegate.addFirst(invoker, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addLast(String name, ChannelHandler handler) {
        this.delegate.addLast(name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addLast(EventExecutorGroup group, String name, ChannelHandler handler) {
        this.delegate.addLast(group, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addLast(ChannelHandlerInvoker invoker, String name, ChannelHandler handler) {
        this.delegate.addLast(invoker, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        return this.delegate.addBefore(baseName, name, handler);
    }

    @Override
    public ChannelPipeline addBefore(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        this.delegate.addBefore(group, baseName, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addBefore(ChannelHandlerInvoker invoker, String baseName, String name, ChannelHandler handler) {
        this.delegate.addBefore(invoker, baseName, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        this.delegate.addAfter(baseName, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addAfter(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        this.delegate.addAfter(group, baseName, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addAfter(ChannelHandlerInvoker invoker, String baseName, String name, ChannelHandler handler) {
        this.delegate.addAfter(invoker, baseName, name, handler);
        return this;
    }

    @Override
    public ChannelPipeline addFirst(ChannelHandler ... handlers) {
        this.delegate.addFirst(handlers);
        return this;
    }

    @Override
    public ChannelPipeline addFirst(EventExecutorGroup group, ChannelHandler ... handlers) {
        this.delegate.addFirst(group, handlers);
        return this;
    }

    @Override
    public ChannelPipeline addFirst(ChannelHandlerInvoker invoker, ChannelHandler ... handlers) {
        this.delegate.addFirst(invoker, handlers);
        return this;
    }

    @Override
    public ChannelPipeline addLast(ChannelHandler ... handlers) {
        this.delegate.addLast(handlers);
        return this;
    }

    @Override
    public ChannelPipeline addLast(EventExecutorGroup group, ChannelHandler ... handlers) {
        this.delegate.addLast(group, handlers);
        return this;
    }

    @Override
    public ChannelPipeline addLast(ChannelHandlerInvoker invoker, ChannelHandler ... handlers) {
        this.delegate.addLast(invoker, handlers);
        return this;
    }

    @Override
    public ChannelPipeline remove(ChannelHandler handler) {
        this.delegate.remove(handler);
        return this;
    }

    @Override
    public ChannelHandler remove(String name) {
        return this.delegate.remove(name);
    }

    @Override
    public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return this.delegate.remove(handlerType);
    }

    @Override
    public ChannelHandler removeFirst() {
        return this.delegate.removeFirst();
    }

    @Override
    public ChannelHandler removeLast() {
        return this.delegate.removeLast();
    }

    @Override
    public ChannelPipeline replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.delegate.replace(oldHandler, newName, newHandler);
        return this;
    }

    @Override
    public ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.delegate.replace(oldName, newName, newHandler);
    }

    @Override
    public <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return this.delegate.replace(oldHandlerType, newName, newHandler);
    }

    @Override
    public ChannelHandler first() {
        return this.delegate.first();
    }

    @Override
    public ChannelHandlerContext firstContext() {
        return this.delegate.firstContext();
    }

    @Override
    public ChannelHandler last() {
        return this.delegate.last();
    }

    @Override
    public ChannelHandlerContext lastContext() {
        return this.delegate.lastContext();
    }

    @Override
    public ChannelHandler get(String name) {
        return this.delegate.get(name);
    }

    @Override
    public <T extends ChannelHandler> T get(Class<T> handlerType) {
        return this.delegate.get(handlerType);
    }

    @Override
    public ChannelHandlerContext context(ChannelHandler handler) {
        return this.delegate.context(handler);
    }

    @Override
    public ChannelHandlerContext context(String name) {
        return this.delegate.context(name);
    }

    @Override
    public ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        return this.delegate.context(handlerType);
    }

    @Override
    public Channel channel() {
        return this.delegate.channel();
    }

    @Override
    public List<String> names() {
        return this.delegate.names();
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        return this.delegate.toMap();
    }

    @Override
    public ChannelPipeline fireChannelRegistered() {
        this.delegate.fireChannelRegistered();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelUnregistered() {
        this.delegate.fireChannelUnregistered();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelActive() {
        this.delegate.fireChannelActive();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelInactive() {
        this.delegate.fireChannelInactive();
        return this;
    }

    @Override
    public ChannelPipeline fireExceptionCaught(Throwable cause) {
        this.delegate.fireExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelPipeline fireUserEventTriggered(Object event) {
        this.delegate.fireUserEventTriggered(event);
        return this;
    }

    @Override
    public ChannelPipeline fireChannelRead(Object msg) {
        this.delegate.fireChannelRead(msg);
        return this;
    }

    @Override
    public ChannelPipeline fireChannelReadComplete() {
        this.delegate.fireChannelReadComplete();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelWritabilityChanged() {
        this.delegate.fireChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.delegate.bind(localAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.delegate.connect(remoteAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.delegate.connect(remoteAddress, localAddress);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.delegate.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.delegate.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.delegate.deregister();
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.bind(localAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.delegate.disconnect(promise);
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        return this.delegate.close(promise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        return this.delegate.deregister(promise);
    }

    @Override
    public ChannelPipeline read() {
        return this.delegate.read();
    }

    @Override
    public ChannelFuture write(Object msg) {
        return this.delegate.write(msg);
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.delegate.write(msg, promise);
    }

    @Override
    public ChannelPipeline flush() {
        return this.delegate.flush();
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.delegate.writeAndFlush(msg, promise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.delegate.writeAndFlush(msg);
    }

    @Override
    public Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.delegate.iterator();
    }
}

