/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.DetachedChannelPipeline;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventPublisher;
import io.reactivex.netty.server.ServerState;
import io.reactivex.netty.ssl.DefaultSslCodec;
import io.reactivex.netty.ssl.SslCodec;
import java.io.File;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;

public class TcpServerState<R, W>
extends ServerState<R, W> {
    private final TcpServerEventPublisher eventPublisher;
    private final boolean secure;

    protected TcpServerState(SocketAddress socketAddress, EventLoopGroup parent, EventLoopGroup child, Class<? extends ServerChannel> channelClass) {
        super(socketAddress, parent, child, channelClass);
        this.secure = false;
        this.eventPublisher = new TcpServerEventPublisher();
    }

    protected TcpServerState(TcpServerState<?, ?> toCopy, SslCodec sslCodec) {
        super(toCopy, toCopy.detachedPipeline.configure((Action1)sslCodec));
        this.secure = true;
        this.eventPublisher = toCopy.eventPublisher.copy();
    }

    protected TcpServerState(TcpServerState<R, W> toCopy, SocketAddress socketAddress) {
        super(toCopy, socketAddress);
        this.secure = toCopy.secure;
        this.eventPublisher = toCopy.eventPublisher.copy();
    }

    protected TcpServerState(TcpServerState<R, W> toCopy, ServerBootstrap clone) {
        super(toCopy, clone);
        this.secure = toCopy.secure;
        this.eventPublisher = toCopy.eventPublisher.copy();
    }

    protected TcpServerState(TcpServerState<?, ?> toCopy, DetachedChannelPipeline newPipeline) {
        super(toCopy, newPipeline);
        this.secure = toCopy.secure;
        this.eventPublisher = toCopy.eventPublisher.copy();
    }

    public TcpServerState<R, W> secure(Func1<ByteBufAllocator, SSLEngine> sslEngineFactory) {
        return this.secure((SslCodec)new DefaultSslCodec(sslEngineFactory));
    }

    public TcpServerState<R, W> secure(SSLEngine sslEngine) {
        return this.secure((SslCodec)new DefaultSslCodec(sslEngine));
    }

    public TcpServerState<R, W> secure(SslCodec sslCodec) {
        return new TcpServerState<R, W>(this, sslCodec);
    }

    public TcpServerState<R, W> unsafeSecure() {
        return this.secure((SslCodec)new DefaultSslCodec((Func1)new Func1<ByteBufAllocator, SSLEngine>(){

            public SSLEngine call(ByteBufAllocator allocator) {
                try {
                    SelfSignedCertificate ssc = new SelfSignedCertificate();
                    return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build().newEngine(allocator);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }));
    }

    protected ServerState<R, W> copyBootstrapOnly() {
        return new TcpServerState<R, W>(this, this.bootstrap.clone());
    }

    protected <RR, WW> ServerState<RR, WW> copy() {
        return new TcpServerState<R, W>(this, this.detachedPipeline.copy());
    }

    protected ServerState<R, W> copy(SocketAddress newSocketAddress) {
        return new TcpServerState<R, W>(this, this.socketAddress);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public TcpServerEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public static <RR, WW> TcpServerState<RR, WW> create(SocketAddress socketAddress) {
        return TcpServerState.create(socketAddress, RxNetty.getRxEventLoopProvider().globalServerEventLoop(true), RxNetty.isUsingNativeTransport() ? EpollServerSocketChannel.class : NioServerSocketChannel.class);
    }

    public static <RR, WW> TcpServerState<RR, WW> create(SocketAddress socketAddress, EventLoopGroup group, Class<? extends ServerChannel> channelClass) {
        return TcpServerState.create(socketAddress, group, group, channelClass);
    }

    public static <RR, WW> TcpServerState<RR, WW> create(SocketAddress socketAddress, EventLoopGroup parent, EventLoopGroup child, Class<? extends ServerChannel> channelClass) {
        return new TcpServerState(socketAddress, parent, child, channelClass);
    }
}

