/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.ScoreFormatter;
import org.openjdk.jmh.util.Statistics;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfNormProfiler
implements ExternalProfiler {
    private static final String[] interestingEvents = new String[]{"cycles", "instructions", "branches", "branch-misses", "bus-cycles", "ref-cycles", "context-switches", "cpu-migrations", "page-faults", "minor-faults", "major-faults", "alignment-faults", "emulation-faults", "L1-dcache-loads", "L1-dcache-load-misses", "L1-dcache-stores", "L1-dcache-store-misses", "L1-icache-loads", "L1-icache-load-misses", "LLC-loads", "LLC-stores", "dTLB-loads", "dTLB-load-misses", "dTLB-stores", "dTLB-store-misses", "iTLB-loads", "iTLB-load-misses", "stalled-cycles-frontend", "stalled-cycles-backend"};
    private final int delayMs;
    private final boolean useDefaultStats;
    private final long highPassFilter;
    private final int incrementInterval;
    private final boolean isIncrementable;
    private final Collection<String> supportedEvents = new ArrayList<String>();

    public LinuxPerfNormProfiler(String initLine) throws ProfilerException {
        List<String> userEvents;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter("perfnorm"));
        ArgumentAcceptingOptionSpec<String> optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event+");
        ArgumentAcceptingOptionSpec<Integer> optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optIncrementInterval = parser.accepts("interval", "The interval between incremental updates from a concurrently running perf. Lower values may improve accuracy, while increasing the profiling overhead.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(100, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Long> optHighPassFilter = parser.accepts("highPassFilter", "Ignore event increments larger that this.").withRequiredArg().ofType(Long.class).describedAs("#").defaultsTo(100000000000L, (Long[])new Long[0]);
        ArgumentAcceptingOptionSpec<Boolean> optDefaultStat = parser.accepts("useDefaultStat", "Use \"perf stat -d -d -d\" instead of explicit counter list.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.delayMs = set.valueOf(optDelay);
            this.incrementInterval = set.valueOf(optIncrementInterval);
            this.highPassFilter = set.valueOf(optHighPassFilter);
            this.useDefaultStats = set.valueOf(optDefaultStat);
            userEvents = set.valuesOf(optEvents);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> msgs = Utils.tryWith("perf", "stat", "--log-fd", "2", "--field-separator", ",", "echo", "1");
        if (!msgs.isEmpty()) {
            throw new ProfilerException(msgs.toString());
        }
        Collection<String> incremental = Utils.tryWith("perf", "stat", "--log-fd", "2", "--field-separator", ",", "--interval-print", String.valueOf(this.incrementInterval), "echo", "1");
        this.isIncrementable = incremental.isEmpty();
        if (userEvents != null) {
            for (String ev : userEvents) {
                if (ev.trim().isEmpty()) continue;
                this.supportedEvents.add(ev);
            }
        }
        if (this.supportedEvents.isEmpty()) {
            for (String ev : interestingEvents) {
                Collection<String> res = Utils.tryWith("perf", "stat", "--log-fd", "2", "--field-separator", ",", "--event", "cycles,instructions," + ev, "echo", "1");
                if (!res.isEmpty()) continue;
                this.supportedEvents.add(ev);
            }
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.useDefaultStats) {
            cmd.addAll(Arrays.asList("perf", "stat", "--log-fd", "2", "--field-separator", ",", "--detailed", "--detailed", "--detailed"));
        } else {
            cmd.addAll(Arrays.asList("perf", "stat", "--log-fd", "2", "--field-separator", ",", "--event", Utils.join(this.supportedEvents, ",")));
        }
        if (this.isIncrementable) {
            cmd.addAll(Arrays.asList("-I", String.valueOf(this.incrementInterval)));
        }
        return cmd;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return this.process(br, stdOut, stdErr);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf statistics, normalized by operation count";
    }

    public long getDelay(BenchmarkResult br) {
        if (this.delayMs == -1) {
            BenchmarkResultMetaData md = br.getMetadata();
            if (md != null) {
                return TimeUnit.MILLISECONDS.toNanos(md.getMeasurementTime() - md.getStartTime());
            }
            IterationParams wp = br.getParams().getWarmup();
            return (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + TimeUnit.SECONDS.toNanos(1L);
        }
        return TimeUnit.MILLISECONDS.toNanos(this.delayMs);
    }

    private Collection<? extends Result> process(BenchmarkResult br, File stdOut, File stdErr) {
        Set<PerfResult> set;
        FileReader fr;
        block19: {
            BenchmarkResultMetaData md;
            String line;
            HashMultiset<String> events = new HashMultiset<String>();
            fr = null;
            fr = new FileReader(stdErr);
            BufferedReader reader = new BufferedReader(fr);
            long delayNs = this.getDelay(br);
            NumberFormat nf = NumberFormat.getInstance();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (this.isIncrementable) {
                    String event;
                    String count;
                    String time;
                    String[] split = line.split(",");
                    if (split.length == 3) {
                        time = split[0].trim();
                        count = split[1].trim();
                        event = split[2].trim();
                    } else {
                        if (split.length < 4) continue;
                        time = split[0].trim();
                        count = split[1].trim();
                        event = split[3].trim();
                    }
                    try {
                        double timeSec = nf.parse(time).doubleValue();
                        if (timeSec * (double)TimeUnit.SECONDS.toNanos(1L) < (double)delayNs) {
                        }
                    }
                    catch (ParseException e) {}
                    continue;
                    try {
                        long lValue = nf.parse(count).longValue();
                        if (lValue > this.highPassFilter) continue;
                        events.add(event, lValue);
                    }
                    catch (ParseException e) {}
                    continue;
                }
                int idx = line.lastIndexOf(",");
                if (idx == -1) continue;
                String count = line.substring(0, idx).trim();
                String event = line.substring(idx + 1).trim();
                try {
                    long lValue = nf.parse(count).longValue();
                    events.add(event, lValue);
                }
                catch (ParseException e) {}
            }
            if (!this.isIncrementable) {
                System.out.println();
                System.out.println();
                System.out.println("WARNING: Your system uses old \"perf\", which cannot print data incrementally (-I).\nTherefore, perf performance data includes benchmark warmup.");
            }
            if ((md = br.getMetadata()) == null) break block19;
            long totalOpts = this.isIncrementable ? md.getMeasurementOps() : md.getWarmupOps() + md.getMeasurementOps();
            ArrayList<PerfResult> results = new ArrayList<PerfResult>();
            for (String key : events.keys()) {
                results.add(new PerfResult(key, (double)events.count(key) * 1.0 / (double)totalOpts));
            }
            long cycles = events.count("cycles");
            long instructions = events.count("instructions");
            if (cycles != 0L && instructions != 0L) {
                results.add(new PerfResult("CPI", 1.0 * (double)cycles / (double)instructions));
            }
            ArrayList<PerfResult> arrayList = results;
            FileUtils.safelyClose(fr);
            return arrayList;
        }
        try {
            set = Collections.singleton(new PerfResult("N/A", Double.NaN));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileUtils.safelyClose(fr);
                throw throwable;
            }
        }
        FileUtils.safelyClose(fr);
        return set;
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            String key = "";
            ListStatistics stat = new ListStatistics();
            for (PerfResult r : results) {
                key = r.key;
                stat.addValue(r.getScore());
            }
            return new PerfResult(key, stat);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = -1262685915873231436L;
        private final String key;

        public PerfResult(String key, double value) {
            this(key, PerfResult.of(value));
        }

        public PerfResult(String key, Statistics stat) {
            super(ResultRole.SECONDARY, "\u00b7" + key, stat, "#/op", AggregationPolicy.AVG);
            this.key = key;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return String.format(" %s %s/op", ScoreFormatter.format(this.getScore()), this.key);
        }

        @Override
        public String extendedInfo() {
            return "";
        }
    }
}

