/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.openjdk.jmh.generators.annotations.APFieldInfo;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.annotations.APMethodInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.MethodInfo;

class APClassInfo
extends APMetadataInfo
implements ClassInfo {
    private final TypeElement el;
    private final boolean isSpecial;
    private final TypeMirror mirror;

    public APClassInfo(ProcessingEnvironment processEnv, TypeElement element) {
        super(processEnv, element);
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        this.el = element;
        this.isSpecial = false;
        this.mirror = null;
    }

    public APClassInfo(ProcessingEnvironment processEnv, TypeMirror mirror) {
        super(processEnv, null);
        this.mirror = mirror;
        this.isSpecial = mirror.getKind().isPrimitive() || mirror.getKind() == TypeKind.ARRAY;
        this.el = this.isSpecial ? null : (TypeElement)processEnv.getTypeUtils().asElement(mirror);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        if (this.isSpecial) {
            return null;
        }
        return this.el.getAnnotation(annClass);
    }

    @Override
    public Collection<MethodInfo> getConstructors() {
        if (this.isSpecial) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ExecutableElement e : ElementFilter.constructorsIn(this.el.getEnclosedElements())) {
            mis.add(new APMethodInfo(this.processEnv, this, e));
        }
        return mis;
    }

    @Override
    public String getName() {
        if (this.isSpecial) {
            return this.mirror.toString();
        }
        return this.el.getSimpleName().toString();
    }

    @Override
    public String getQualifiedName() {
        if (this.isSpecial) {
            return this.mirror.toString();
        }
        return this.el.getQualifiedName().toString();
    }

    @Override
    public Collection<FieldInfo> getFields() {
        if (this.isSpecial) {
            return Collections.emptyList();
        }
        ArrayList<FieldInfo> ls = new ArrayList<FieldInfo>();
        for (VariableElement e : ElementFilter.fieldsIn(this.el.getEnclosedElements())) {
            ls.add(new APFieldInfo(this.processEnv, e));
        }
        return ls;
    }

    @Override
    public Collection<MethodInfo> getMethods() {
        if (this.isSpecial) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ExecutableElement e : ElementFilter.methodsIn(this.el.getEnclosedElements())) {
            mis.add(new APMethodInfo(this.processEnv, this, e));
        }
        return mis;
    }

    @Override
    public String getPackageName() {
        if (this.isSpecial) {
            return "";
        }
        Element walk = this.el;
        while (walk.getKind() != ElementKind.PACKAGE) {
            walk = walk.getEnclosingElement();
        }
        return ((PackageElement)walk).getQualifiedName().toString();
    }

    @Override
    public ClassInfo getSuperClass() {
        if (this.isSpecial) {
            return null;
        }
        TypeMirror superclass = this.el.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        TypeElement element = (TypeElement)this.processEnv.getTypeUtils().asElement(superclass);
        return new APClassInfo(this.processEnv, element);
    }

    @Override
    public ClassInfo getDeclaringClass() {
        if (this.isSpecial) {
            return null;
        }
        Element enclosingElement = this.el.getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS) {
            return new APClassInfo(this.processEnv, (TypeElement)enclosingElement);
        }
        return null;
    }

    @Override
    public boolean isAbstract() {
        if (this.isSpecial) {
            return false;
        }
        return this.el.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean isPublic() {
        if (this.isSpecial) {
            return true;
        }
        return this.el.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isStrictFP() {
        if (this.isSpecial) {
            return false;
        }
        return this.el.getModifiers().contains((Object)Modifier.STRICTFP);
    }

    @Override
    public boolean isFinal() {
        if (this.isSpecial) {
            return false;
        }
        return this.el.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public boolean isInner() {
        if (this.isSpecial) {
            return false;
        }
        return this.getDeclaringClass() != null && !this.el.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isEnum() {
        if (this.isSpecial) {
            return false;
        }
        return this.el.getKind() == ElementKind.ENUM;
    }

    @Override
    public Collection<String> getEnumConstants() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.el.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result.add(element.getSimpleName().toString());
        }
        return result;
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

