/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.util;

import io.netty.channel.ChannelHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.EnumMap;
import rx.functions.Func0;

public class LoggingHandlerFactory
implements Func0<ChannelHandler> {
    private static final EnumMap<LogLevel, LoggingHandlerFactory> factories = new EnumMap(LogLevel.class);
    private final LoggingHandler loggingHandler;

    public LoggingHandlerFactory(LogLevel wireLogginLevel) {
        this.loggingHandler = new LoggingHandler(wireLogginLevel);
    }

    public static LoggingHandler get(LogLevel logLevel) {
        return LoggingHandlerFactory.factories.get((Object)((Object)logLevel)).loggingHandler;
    }

    public static LoggingHandlerFactory getFactory(LogLevel logLevel) {
        return factories.get((Object)logLevel);
    }

    @Override
    public ChannelHandler call() {
        return this.loggingHandler;
    }

    static {
        for (LogLevel logLevel : LogLevel.values()) {
            factories.put(logLevel, new LoggingHandlerFactory(logLevel));
        }
    }
}

