/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.server.events;

import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SafeTcpServerEventListener
extends TcpServerEventListener
implements SafeEventListener {
    private final TcpServerEventListener delegate;
    private final AtomicBoolean completed = new AtomicBoolean();

    public SafeTcpServerEventListener(TcpServerEventListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.delegate.onCompleted();
        }
    }

    @Override
    public void onNewClientConnected() {
        if (!this.completed.get()) {
            this.delegate.onNewClientConnected();
        }
    }

    @Override
    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingStart(duration, timeUnit);
        }
    }

    @Override
    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onByteRead(long bytesRead) {
        if (!this.completed.get()) {
            this.delegate.onByteRead(bytesRead);
        }
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        if (!this.completed.get()) {
            this.delegate.onByteWritten(bytesWritten);
        }
    }

    @Override
    public void onFlushStart() {
        if (!this.completed.get()) {
            this.delegate.onFlushStart();
        }
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onFlushComplete(duration, timeUnit);
        }
    }

    @Override
    public void onWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onWriteStart();
        }
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onWriteSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onWriteFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onConnectionCloseStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseStart();
        }
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onCustomEvent(Object event) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event);
        }
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit);
        }
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit, throwable);
        }
    }

    @Override
    public void onCustomEvent(Object event, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, throwable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeTcpServerEventListener)) {
            return false;
        }
        SafeTcpServerEventListener that = (SafeTcpServerEventListener)o;
        return !(this.delegate == null ? that.delegate != null : !this.delegate.equals(that.delegate));
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }
}

