/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.tcp;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.metrics.ClientMetricEventsListener;
import io.reactivex.netty.spectator.SpectatorUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TcpClientListener<T extends ClientMetricsEvent<?>>
extends ClientMetricEventsListener<T> {
    private final AtomicInteger liveConnections;
    private final Counter connectionCount;
    private final AtomicInteger pendingConnects;
    private final Counter failedConnects;
    private final Timer connectionTimes;
    private final AtomicInteger pendingConnectionClose;
    private final Counter failedConnectionClose;
    private final AtomicInteger pendingPoolAcquires;
    private final Counter failedPoolAcquires;
    private final Timer poolAcquireTimes;
    private final AtomicInteger pendingPoolReleases;
    private final Counter failedPoolReleases;
    private final Timer poolReleaseTimes;
    private final Counter poolAcquires;
    private final Counter poolEvictions;
    private final Counter poolReuse;
    private final Counter poolReleases;
    private final AtomicInteger pendingWrites;
    private final AtomicInteger pendingFlushes;
    private final Counter bytesWritten;
    private final Timer writeTimes;
    private final Counter bytesRead;
    private final Counter failedWrites;
    private final Counter failedFlushes;
    private final Timer flushTimes;

    protected TcpClientListener(String monitorId) {
        this.liveConnections = SpectatorUtils.newGauge("liveConnections", monitorId, new AtomicInteger());
        this.connectionCount = SpectatorUtils.newCounter("connectionCount", monitorId);
        this.pendingConnects = SpectatorUtils.newGauge("pendingConnects", monitorId, new AtomicInteger());
        this.failedConnects = SpectatorUtils.newCounter("failedConnects", monitorId);
        this.connectionTimes = SpectatorUtils.newTimer("connectionTimes", monitorId);
        this.pendingConnectionClose = SpectatorUtils.newGauge("pendingConnectionClose", monitorId, new AtomicInteger());
        this.failedConnectionClose = SpectatorUtils.newCounter("failedConnectionClose", monitorId);
        this.pendingPoolAcquires = SpectatorUtils.newGauge("pendingPoolAcquires", monitorId, new AtomicInteger());
        this.poolAcquireTimes = SpectatorUtils.newTimer("poolAcquireTimes", monitorId);
        this.failedPoolAcquires = SpectatorUtils.newCounter("failedPoolAcquires", monitorId);
        this.pendingPoolReleases = SpectatorUtils.newGauge("pendingPoolReleases", monitorId, new AtomicInteger());
        this.poolReleaseTimes = SpectatorUtils.newTimer("poolReleaseTimes", monitorId);
        this.failedPoolReleases = SpectatorUtils.newCounter("failedPoolReleases", monitorId);
        this.poolAcquires = SpectatorUtils.newCounter("poolAcquires", monitorId);
        this.poolEvictions = SpectatorUtils.newCounter("poolEvictions", monitorId);
        this.poolReuse = SpectatorUtils.newCounter("poolReuse", monitorId);
        this.poolReleases = SpectatorUtils.newCounter("poolReleases", monitorId);
        this.pendingWrites = SpectatorUtils.newGauge("pendingWrites", monitorId, new AtomicInteger());
        this.pendingFlushes = SpectatorUtils.newGauge("pendingFlushes", monitorId, new AtomicInteger());
        this.bytesWritten = SpectatorUtils.newCounter("bytesWritten", monitorId);
        this.writeTimes = SpectatorUtils.newTimer("writeTimes", monitorId);
        this.bytesRead = SpectatorUtils.newCounter("bytesRead", monitorId);
        this.failedWrites = SpectatorUtils.newCounter("failedWrites", monitorId);
        this.failedFlushes = SpectatorUtils.newCounter("failedFlushes", monitorId);
        this.flushTimes = SpectatorUtils.newTimer("flushTimes", monitorId);
    }

    protected void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingFlushes.decrementAndGet();
        this.failedFlushes.increment();
    }

    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
        this.pendingFlushes.decrementAndGet();
        this.flushTimes.record(duration, timeUnit);
    }

    protected void onFlushStart() {
        this.pendingFlushes.incrementAndGet();
    }

    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingWrites.decrementAndGet();
        this.failedWrites.increment();
    }

    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
        this.pendingWrites.decrementAndGet();
        this.bytesWritten.increment(bytesWritten);
        this.writeTimes.record(duration, timeUnit);
    }

    protected void onWriteStart() {
        this.pendingWrites.incrementAndGet();
    }

    protected void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingPoolReleases.decrementAndGet();
        this.poolReleases.increment();
        this.failedPoolReleases.increment();
    }

    protected void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.pendingPoolReleases.decrementAndGet();
        this.poolReleases.increment();
        this.poolReleaseTimes.record(duration, timeUnit);
    }

    protected void onPoolReleaseStart() {
        this.pendingPoolReleases.incrementAndGet();
    }

    protected void onPooledConnectionEviction() {
        this.poolEvictions.increment();
    }

    protected void onPooledConnectionReuse(long duration, TimeUnit timeUnit) {
        this.poolReuse.increment();
    }

    protected void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingPoolAcquires.decrementAndGet();
        this.poolAcquires.increment();
        this.failedPoolAcquires.increment();
    }

    protected void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.pendingPoolAcquires.decrementAndGet();
        this.poolAcquires.increment();
        this.poolAcquireTimes.record(duration, timeUnit);
    }

    protected void onPoolAcquireStart() {
        this.pendingPoolAcquires.incrementAndGet();
    }

    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.liveConnections.decrementAndGet();
        this.pendingConnectionClose.decrementAndGet();
        this.failedConnectionClose.increment();
    }

    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.liveConnections.decrementAndGet();
        this.pendingConnectionClose.decrementAndGet();
    }

    protected void onConnectionCloseStart() {
        this.pendingConnectionClose.incrementAndGet();
    }

    protected void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingConnects.decrementAndGet();
        this.failedConnects.increment();
    }

    protected void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.pendingConnects.decrementAndGet();
        this.liveConnections.incrementAndGet();
        this.connectionCount.increment();
        this.connectionTimes.record(duration, timeUnit);
    }

    protected void onConnectStart() {
        this.pendingConnects.incrementAndGet();
    }

    public void onCompleted() {
    }

    public void onSubscribe() {
    }

    public long getLiveConnections() {
        return this.liveConnections.get();
    }

    public long getConnectionCount() {
        return this.connectionCount.count();
    }

    public long getPendingConnects() {
        return this.pendingConnects.get();
    }

    public long getFailedConnects() {
        return this.failedConnects.count();
    }

    public Timer getConnectionTimes() {
        return this.connectionTimes;
    }

    public long getPendingConnectionClose() {
        return this.pendingConnectionClose.get();
    }

    public long getFailedConnectionClose() {
        return this.failedConnectionClose.count();
    }

    public long getPendingPoolAcquires() {
        return this.pendingPoolAcquires.get();
    }

    public long getFailedPoolAcquires() {
        return this.failedPoolAcquires.count();
    }

    public Timer getPoolAcquireTimes() {
        return this.poolAcquireTimes;
    }

    public long getPendingPoolReleases() {
        return this.pendingPoolReleases.get();
    }

    public long getFailedPoolReleases() {
        return this.failedPoolReleases.count();
    }

    public Timer getPoolReleaseTimes() {
        return this.poolReleaseTimes;
    }

    public long getPoolEvictions() {
        return this.poolEvictions.count();
    }

    public long getPoolReuse() {
        return this.poolReuse.count();
    }

    public long getPendingWrites() {
        return this.pendingWrites.get();
    }

    public long getPendingFlushes() {
        return this.pendingFlushes.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.count();
    }

    public Timer getWriteTimes() {
        return this.writeTimes;
    }

    public long getBytesRead() {
        return this.bytesRead.count();
    }

    public long getFailedWrites() {
        return this.failedWrites.count();
    }

    public long getFailedFlushes() {
        return this.failedFlushes.count();
    }

    public Timer getFlushTimes() {
        return this.flushTimes;
    }

    public long getPoolAcquires() {
        return this.poolAcquires.count();
    }

    public long getPoolReleases() {
        return this.poolReleases.count();
    }

    public static TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>> newListener(String monitorId) {
        return new TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>>(monitorId);
    }
}

