/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http.websocket;

import com.netflix.spectator.api.Counter;
import io.reactivex.netty.metrics.WebSocketServerMetricEventsListener;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerMetricsEvent;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.spectator.SpectatorUtils;
import io.reactivex.netty.spectator.tcp.TcpServerListener;
import java.util.concurrent.TimeUnit;

public class WebSocketServerListener
extends TcpServerListener<ServerMetricsEvent<?>> {
    private final Counter processedHandshakes;
    private final Counter failedHandshakes;
    private final Counter webSocketWrites;
    private final Counter getWebSocketReads;
    private final WebSocketServerMetricEventsListenerImpl delegate = new WebSocketServerMetricEventsListenerImpl();

    protected WebSocketServerListener(String monitorId) {
        super(monitorId);
        this.processedHandshakes = SpectatorUtils.newCounter("processedHandshakes", monitorId);
        this.failedHandshakes = SpectatorUtils.newCounter("failedHandshakes", monitorId);
        this.webSocketWrites = SpectatorUtils.newCounter("webSocketWrites", monitorId);
        this.getWebSocketReads = SpectatorUtils.newCounter("getWebSocketReads", monitorId);
    }

    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType().getClass() == WebSocketServerMetricsEvent.EventType.class) {
            this.delegate.onEvent(event, duration, timeUnit, throwable, value);
        } else {
            super.onEvent(event, duration, timeUnit, throwable, value);
        }
    }

    public long getProcessedHandshakes() {
        return this.processedHandshakes.count();
    }

    public long getFailedHandshakes() {
        return this.failedHandshakes.count();
    }

    public long getWebSocketWrites() {
        return this.webSocketWrites.count();
    }

    public long getWebSocketReads() {
        return this.getWebSocketReads.count();
    }

    public static WebSocketServerListener newWebSocketListener(String monitorId) {
        return new WebSocketServerListener(monitorId);
    }

    private class WebSocketServerMetricEventsListenerImpl
    extends WebSocketServerMetricEventsListener {
        private WebSocketServerMetricEventsListenerImpl() {
        }

        protected void onHandshakeProcessed() {
            WebSocketServerListener.this.processedHandshakes.increment();
        }

        protected void onHandshakeFailure() {
            WebSocketServerListener.this.processedHandshakes.increment();
            WebSocketServerListener.this.failedHandshakes.increment();
        }

        protected void onWebSocketWrites() {
            WebSocketServerListener.this.webSocketWrites.increment();
        }

        protected void onWebSocketReads() {
            WebSocketServerListener.this.getWebSocketReads.increment();
        }
    }
}

