/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import io.reactivex.netty.metrics.HttpServerMetricEventsListener;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.spectator.SpectatorUtils;
import io.reactivex.netty.spectator.tcp.TcpServerListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpServerListener
extends TcpServerListener<ServerMetricsEvent<?>> {
    private final AtomicInteger requestBacklog;
    private final AtomicInteger inflightRequests;
    private final Counter processedRequests;
    private final Counter failedRequests;
    private final Counter responseWriteFailed;
    private final Timer responseWriteTimes;
    private final Timer requestReadTimes;
    private final HttpServerMetricEventsListenerImpl delegate;

    protected HttpServerListener(String monitorId) {
        super(monitorId);
        this.requestBacklog = SpectatorUtils.newGauge("requestBacklog", monitorId, new AtomicInteger());
        this.inflightRequests = SpectatorUtils.newGauge("inflightRequests", monitorId, new AtomicInteger());
        this.responseWriteTimes = SpectatorUtils.newTimer("responseWriteTimes", monitorId);
        this.requestReadTimes = SpectatorUtils.newTimer("requestReadTimes", monitorId);
        this.processedRequests = SpectatorUtils.newCounter("processedRequests", monitorId);
        this.failedRequests = SpectatorUtils.newCounter("failedRequests", monitorId);
        this.responseWriteFailed = SpectatorUtils.newCounter("responseWriteFailed", monitorId);
        this.delegate = new HttpServerMetricEventsListenerImpl();
    }

    public void onEvent(ServerMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public long getRequestBacklog() {
        return this.requestBacklog.get();
    }

    public long getInflightRequests() {
        return this.inflightRequests.get();
    }

    public long getProcessedRequests() {
        return this.processedRequests.count();
    }

    public long getFailedRequests() {
        return this.failedRequests.count();
    }

    public long getResponseWriteFailed() {
        return this.responseWriteFailed.count();
    }

    public Timer getResponseWriteTimes() {
        return this.responseWriteTimes;
    }

    public Timer getRequestReadTimes() {
        return this.requestReadTimes;
    }

    public static HttpServerListener newHttpListener(String monitorId) {
        return new HttpServerListener(monitorId);
    }

    private class HttpServerMetricEventsListenerImpl
    extends HttpServerMetricEventsListener {
        private HttpServerMetricEventsListenerImpl() {
        }

        protected void onRequestHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.processedRequests.increment();
            HttpServerListener.this.inflightRequests.decrementAndGet();
            HttpServerListener.this.failedRequests.increment();
        }

        protected void onRequestHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.inflightRequests.decrementAndGet();
            HttpServerListener.this.processedRequests.increment();
        }

        protected void onResponseContentWriteSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.responseWriteTimes.record(duration, timeUnit);
        }

        protected void onResponseHeadersWriteSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.responseWriteTimes.record(duration, timeUnit);
        }

        protected void onResponseContentWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        protected void onResponseHeadersWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.responseWriteFailed.increment();
        }

        protected void onRequestReceiveComplete(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.requestReadTimes.record(duration, timeUnit);
        }

        protected void onRequestHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.requestBacklog.decrementAndGet();
        }

        protected void onNewRequestReceived() {
            HttpServerListener.this.requestBacklog.incrementAndGet();
            HttpServerListener.this.inflightRequests.incrementAndGet();
        }

        protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }

        protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingSuccess(duration, timeUnit);
        }

        protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onConnectionHandlingStart(duration, timeUnit);
        }

        protected void onNewClientConnected() {
            HttpServerListener.this.onNewClientConnected();
        }

        protected void onByteRead(long bytesRead) {
            HttpServerListener.this.onByteRead(bytesRead);
        }

        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpServerListener.this.onFlushSuccess(duration, timeUnit);
        }

        protected void onFlushStart() {
            HttpServerListener.this.onFlushStart();
        }

        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpServerListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpServerListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        protected void onWriteStart() {
            HttpServerListener.this.onWriteStart();
        }
    }
}

