/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.metrics.HttpClientMetricEventsListener;
import io.reactivex.netty.spectator.SpectatorUtils;
import io.reactivex.netty.spectator.tcp.TcpClientListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpClientListener
extends TcpClientListener<ClientMetricsEvent<?>> {
    private final AtomicInteger requestBacklog;
    private final AtomicInteger inflightRequests;
    private final Counter processedRequests;
    private final Counter requestWriteFailed;
    private final Counter failedResponses;
    private final Counter failedContentSource;
    private final Timer requestWriteTimes;
    private final Timer responseReadTimes;
    private final Timer requestProcessingTimes;
    private final HttpClientMetricEventsListenerImpl delegate = new HttpClientMetricEventsListenerImpl();

    protected HttpClientListener(String monitorId) {
        super(monitorId);
        this.requestBacklog = SpectatorUtils.newGauge("requestBacklog", monitorId, new AtomicInteger());
        this.inflightRequests = SpectatorUtils.newGauge("inflightRequests", monitorId, new AtomicInteger());
        this.requestWriteTimes = SpectatorUtils.newTimer("requestWriteTimes", monitorId);
        this.responseReadTimes = SpectatorUtils.newTimer("responseReadTimes", monitorId);
        this.processedRequests = SpectatorUtils.newCounter("processedRequests", monitorId);
        this.requestWriteFailed = SpectatorUtils.newCounter("requestWriteFailed", monitorId);
        this.failedResponses = SpectatorUtils.newCounter("failedResponses", monitorId);
        this.failedContentSource = SpectatorUtils.newCounter("failedContentSource", monitorId);
        this.requestProcessingTimes = SpectatorUtils.newTimer("requestProcessingTimes", monitorId);
    }

    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        this.delegate.onEvent(event, duration, timeUnit, throwable, value);
    }

    public static HttpClientListener newHttpListener(String monitorId) {
        return new HttpClientListener(monitorId);
    }

    public long getRequestBacklog() {
        return this.requestBacklog.get();
    }

    public long getInflightRequests() {
        return this.inflightRequests.get();
    }

    public long getProcessedRequests() {
        return this.processedRequests.count();
    }

    public long getRequestWriteFailed() {
        return this.requestWriteFailed.count();
    }

    public long getFailedResponses() {
        return this.failedResponses.count();
    }

    public long getFailedContentSource() {
        return this.failedContentSource.count();
    }

    public Timer getRequestWriteTimes() {
        return this.requestWriteTimes;
    }

    public Timer getResponseReadTimes() {
        return this.responseReadTimes;
    }

    private class HttpClientMetricEventsListenerImpl
    extends HttpClientMetricEventsListener {
        private HttpClientMetricEventsListenerImpl() {
        }

        protected void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.requestProcessingTimes.record(duration, timeUnit);
        }

        protected void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.inflightRequests.decrementAndGet();
            HttpClientListener.this.processedRequests.increment();
            HttpClientListener.this.responseReadTimes.record(duration, timeUnit);
        }

        protected void onResponseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.inflightRequests.decrementAndGet();
            HttpClientListener.this.processedRequests.increment();
            HttpClientListener.this.failedResponses.increment();
        }

        protected void onRequestContentSourceError(Throwable throwable) {
            HttpClientListener.this.failedContentSource.increment();
        }

        protected void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.requestWriteTimes.record(duration, timeUnit);
        }

        protected void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.inflightRequests.decrementAndGet();
            HttpClientListener.this.requestWriteFailed.increment();
        }

        protected void onRequestHeadersWriteStart() {
            HttpClientListener.this.requestBacklog.decrementAndGet();
        }

        protected void onRequestSubmitted() {
            HttpClientListener.this.requestBacklog.incrementAndGet();
            HttpClientListener.this.inflightRequests.incrementAndGet();
        }

        protected void onByteRead(long bytesRead) {
            HttpClientListener.this.onByteRead(bytesRead);
        }

        protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onFlushFailed(duration, timeUnit, throwable);
        }

        protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onFlushSuccess(duration, timeUnit);
        }

        protected void onFlushStart() {
            HttpClientListener.this.onFlushStart();
        }

        protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onWriteFailed(duration, timeUnit, throwable);
        }

        protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
            HttpClientListener.this.onWriteSuccess(duration, timeUnit, bytesWritten);
        }

        protected void onWriteStart() {
            HttpClientListener.this.onWriteStart();
        }

        protected void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onPoolReleaseFailed(duration, timeUnit, throwable);
        }

        protected void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPoolReleaseSuccess(duration, timeUnit);
        }

        protected void onPoolReleaseStart() {
            HttpClientListener.this.onPoolReleaseStart();
        }

        protected void onPooledConnectionEviction() {
            HttpClientListener.this.onPooledConnectionEviction();
        }

        protected void onPooledConnectionReuse(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPooledConnectionReuse(duration, timeUnit);
        }

        protected void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onPoolAcquireFailed(duration, timeUnit, throwable);
        }

        protected void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onPoolAcquireSuccess(duration, timeUnit);
        }

        protected void onPoolAcquireStart() {
            HttpClientListener.this.onPoolAcquireStart();
        }

        protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onConnectionCloseFailed(duration, timeUnit, throwable);
        }

        protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onConnectionCloseSuccess(duration, timeUnit);
        }

        protected void onConnectionCloseStart() {
            HttpClientListener.this.onConnectionCloseStart();
        }

        protected void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
            HttpClientListener.this.onConnectFailed(duration, timeUnit, throwable);
        }

        protected void onConnectSuccess(long duration, TimeUnit timeUnit) {
            HttpClientListener.this.onConnectSuccess(duration, timeUnit);
        }

        protected void onConnectStart() {
            HttpClientListener.this.onConnectStart();
        }
    }
}

