/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.Serializable;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class WorkloadParams
implements Comparable<WorkloadParams>,
Serializable {
    private final SortedMap<String, Value> params = new TreeMap<String, Value>();

    public WorkloadParams() {
    }

    private WorkloadParams(SortedMap<String, Value> params) {
        this();
        this.params.putAll(params);
    }

    @Override
    public int compareTo(WorkloadParams o) {
        if (!((Object)this.params.keySet()).equals(o.params.keySet())) {
            throw new IllegalStateException("Comparing actual params with different key sets.");
        }
        for (String key : this.params.keySet()) {
            int cr = ((Value)this.params.get(key)).compareTo((Value)o.params.get(key));
            if (cr == 0) continue;
            return cr;
        }
        return 0;
    }

    public void put(String k, String v, int vOrder) {
        this.params.put(k, new Value(v, vOrder));
    }

    public boolean containsKey(String name) {
        return this.params.containsKey(name);
    }

    public String get(String name) {
        Value value = (Value)this.params.get(name);
        if (value == null) {
            return null;
        }
        return value.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadParams that = (WorkloadParams)o;
        return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
    }

    public int hashCode() {
        return this.params != null ? this.params.hashCode() : 0;
    }

    public WorkloadParams copy() {
        return new WorkloadParams(this.params);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public Collection<String> keys() {
        return this.params.keySet();
    }

    private static class Value
    implements Comparable<Value>,
    Serializable {
        private String value;
        private int order;

        public Value(String value, int order) {
            this.value = value;
            this.order = order;
        }

        @Override
        public int compareTo(Value o) {
            return Integer.valueOf(this.order).compareTo(o.order);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return !(this.value != null ? !this.value.equals(value1.value) : value1.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

