/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;

public class BenchmarkResult
implements Serializable {
    private static final long serialVersionUID = 6467912427356048369L;
    private final Collection<IterationResult> iterationResults;
    private final Multimap<String, Result> benchmarkResults = new HashMultimap<String, Result>();
    private final BenchmarkParams params;

    public BenchmarkResult(Collection<IterationResult> data) {
        this.iterationResults = data;
        BenchmarkParams myParams = null;
        for (IterationResult ir : data) {
            BenchmarkParams params = ir.getBenchmarkParams();
            if (myParams != null && !params.equals(myParams)) {
                throw new IllegalStateException("Aggregating the iteration results from different benchmarks");
            }
            myParams = params;
        }
        this.params = myParams;
    }

    public void addBenchmarkResult(Result r) {
        this.benchmarkResults.put(r.getLabel(), r);
    }

    public Collection<IterationResult> getIterationResults() {
        return this.iterationResults;
    }

    public Multimap<String, Result> getBenchmarkResults() {
        return this.benchmarkResults;
    }

    public Result getPrimaryResult() {
        Aggregator aggregator = this.iterationResults.iterator().next().getPrimaryResult().getIterationAggregator();
        ArrayList<Result> aggrs = new ArrayList<Result>();
        for (IterationResult iterationResult : this.iterationResults) {
            aggrs.add(iterationResult.getPrimaryResult());
        }
        for (Result result : this.benchmarkResults.values()) {
            if (!result.getRole().isPrimary()) continue;
            aggrs.add(result);
        }
        return aggregator.aggregate(aggrs);
    }

    public Map<String, Result> getSecondaryResults() {
        ArrayList<Result> results;
        Aggregator aggregator;
        HashSet<String> labels = new HashSet<String>();
        for (IterationResult r : this.iterationResults) {
            labels.addAll(r.getSecondaryResults().keySet());
        }
        TreeMap<String, Result> answers = new TreeMap<String, Result>();
        for (String label : labels) {
            aggregator = this.iterationResults.iterator().next().getSecondaryResults().get(label).getIterationAggregator();
            results = new ArrayList<Result>();
            for (IterationResult iterationResult : this.iterationResults) {
                results.add(iterationResult.getSecondaryResults().get(label));
            }
            answers.put(label, aggregator.aggregate(results));
        }
        for (String label : this.benchmarkResults.keys()) {
            aggregator = this.benchmarkResults.get(label).iterator().next().getIterationAggregator();
            results = new ArrayList();
            for (Result result : this.benchmarkResults.get(label)) {
                if (!result.getRole().isSecondary()) continue;
                results.add(result);
            }
            if (results.isEmpty()) continue;
            answers.put(label, aggregator.aggregate(results));
        }
        return answers;
    }

    public String getScoreUnit() {
        return this.getPrimaryResult().getScoreUnit();
    }

    public BenchmarkParams getParams() {
        return this.params;
    }
}

