/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Timer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultTimer
implements Timer {
    private final Clock clock;
    private final Id id;
    private final AtomicLong count;
    private final AtomicLong totalTime;
    private final Id countId;
    private final Id totalTimeId;

    DefaultTimer(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.count = new AtomicLong(0L);
        this.totalTime = new AtomicLong(0L);
        this.countId = id.withTag("statistic", "count");
        this.totalTimeId = id.withTag("statistic", "totalTime");
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            long nanos = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.totalTime.addAndGet(nanos);
            this.count.incrementAndGet();
        }
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        ms.add(new Measurement(this.countId, now, this.count.get()));
        ms.add(new Measurement(this.totalTimeId, now, this.totalTime.get()));
        return ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public long totalTime() {
        return this.totalTime.get();
    }
}

