/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.AggrMeter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Config;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopCounter;
import com.netflix.spectator.api.NoopDistributionSummary;
import com.netflix.spectator.api.NoopTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Throwables;
import com.netflix.spectator.api.Timer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractRegistry
implements Registry {
    private final Clock clock;
    private final ConcurrentHashMap<Id, Meter> meters;

    public AbstractRegistry(Clock clock) {
        this.clock = clock;
        this.meters = new ConcurrentHashMap();
    }

    protected abstract Counter newCounter(Id var1);

    protected abstract DistributionSummary newDistributionSummary(Id var1);

    protected abstract Timer newTimer(Id var1);

    @Override
    public final Clock clock() {
        return this.clock;
    }

    @Override
    public final Id createId(String name) {
        return new DefaultId(name, TagList.EMPTY);
    }

    @Override
    public final Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, TagList.create(tags));
    }

    private void logTypeError(Id id, Class<?> desired, Class<?> found) {
        String dtype = desired.getName();
        String ftype = found.getName();
        String msg = String.format("cannot access '%s' as a %s, it already exists as a %s", id, dtype, ftype);
        Throwables.propagate(new IllegalStateException(msg));
    }

    private void addToAggr(Meter aggr, Meter meter) {
        if (aggr instanceof AggrMeter) {
            ((AggrMeter)aggr).add(meter);
        } else {
            this.logTypeError(meter.id(), meter.getClass(), aggr.getClass());
        }
    }

    private Meter putIfAbsent(Id id, Meter m, Meter fallback) {
        return this.meters.size() >= Config.maxNumberOfMeters() ? fallback : this.meters.putIfAbsent(id, m);
    }

    @Override
    public final void register(Meter meter) {
        Meter m = this.meters.get(meter.id());
        if (m == null) {
            if (this.meters.size() >= Config.maxNumberOfMeters()) {
                return;
            }
            AggrMeter aggr = new AggrMeter(meter.id());
            m = this.meters.putIfAbsent(meter.id(), aggr);
            if (m == null) {
                aggr.add(meter);
            } else {
                this.addToAggr(m, meter);
            }
        } else {
            this.addToAggr(m, meter);
        }
    }

    @Override
    public final Counter counter(Id id) {
        Counter c;
        Meter m = this.meters.get(id);
        if (m == null && (m = this.putIfAbsent(id, c = this.newCounter(id), NoopCounter.INSTANCE)) == null) {
            m = c;
        }
        if (!(m instanceof Counter)) {
            this.logTypeError(id, Counter.class, m.getClass());
            m = NoopCounter.INSTANCE;
        }
        return (Counter)m;
    }

    @Override
    public final DistributionSummary distributionSummary(Id id) {
        DistributionSummary s;
        Meter m = this.meters.get(id);
        if (m == null && (m = this.putIfAbsent(id, s = this.newDistributionSummary(id), NoopDistributionSummary.INSTANCE)) == null) {
            m = s;
        }
        if (!(m instanceof DistributionSummary)) {
            this.logTypeError(id, DistributionSummary.class, m.getClass());
            m = NoopDistributionSummary.INSTANCE;
        }
        return (DistributionSummary)m;
    }

    @Override
    public final Timer timer(Id id) {
        Timer t;
        Meter m = this.meters.get(id);
        if (m == null && (m = this.putIfAbsent(id, t = this.newTimer(id), NoopTimer.INSTANCE)) == null) {
            m = t;
        }
        if (!(m instanceof Timer)) {
            this.logTypeError(id, Timer.class, m.getClass());
            m = NoopTimer.INSTANCE;
        }
        return (Timer)m;
    }

    @Override
    public final Meter get(Id id) {
        return this.meters.get(id);
    }

    @Override
    public final Iterator<Meter> iterator() {
        return this.meters.values().iterator();
    }
}

