/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.tcp;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Timer;
import io.reactivex.netty.metrics.ServerMetricEventsListener;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.spectator.SpectatorUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TcpServerListener<T extends ServerMetricsEvent<?>>
extends ServerMetricEventsListener<T> {
    private final AtomicInteger liveConnections;
    private final AtomicInteger inflightConnections;
    private final Counter failedConnections;
    private final Timer connectionProcessingTimes;
    private final AtomicInteger pendingConnectionClose;
    private final Counter failedConnectionClose;
    private final Timer connectionCloseTimes;
    private final AtomicInteger pendingWrites;
    private final AtomicInteger pendingFlushes;
    private final Counter bytesWritten;
    private final Timer writeTimes;
    private final Counter bytesRead;
    private final Counter failedWrites;
    private final Counter failedFlushes;
    private final Timer flushTimes;

    protected TcpServerListener(String monitorId) {
        this.liveConnections = SpectatorUtils.newGauge("liveConnections", monitorId, new AtomicInteger());
        this.inflightConnections = SpectatorUtils.newGauge("inflightConnections", monitorId, new AtomicInteger());
        this.pendingConnectionClose = SpectatorUtils.newGauge("pendingConnectionClose", monitorId, new AtomicInteger());
        this.failedConnectionClose = SpectatorUtils.newCounter("failedConnectionClose", monitorId);
        this.failedConnections = SpectatorUtils.newCounter("failedConnections", monitorId);
        this.connectionProcessingTimes = SpectatorUtils.newTimer("connectionProcessingTimes", monitorId);
        this.connectionCloseTimes = SpectatorUtils.newTimer("connectionCloseTimes", monitorId);
        this.pendingWrites = SpectatorUtils.newGauge("pendingWrites", monitorId, new AtomicInteger());
        this.pendingFlushes = SpectatorUtils.newGauge("pendingFlushes", monitorId, new AtomicInteger());
        this.bytesWritten = SpectatorUtils.newCounter("bytesWritten", monitorId);
        this.writeTimes = SpectatorUtils.newTimer("writeTimes", monitorId);
        this.bytesRead = SpectatorUtils.newCounter("bytesRead", monitorId);
        this.failedWrites = SpectatorUtils.newCounter("failedWrites", monitorId);
        this.failedFlushes = SpectatorUtils.newCounter("failedFlushes", monitorId);
        this.flushTimes = SpectatorUtils.newTimer("flushTimes", monitorId);
    }

    @Override
    protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.inflightConnections.decrementAndGet();
        this.failedConnections.increment();
    }

    @Override
    protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.inflightConnections.decrementAndGet();
        this.connectionProcessingTimes.record(duration, timeUnit);
    }

    @Override
    protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.inflightConnections.incrementAndGet();
    }

    @Override
    protected void onConnectionCloseStart() {
        this.pendingConnectionClose.incrementAndGet();
    }

    @Override
    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.liveConnections.decrementAndGet();
        this.pendingConnectionClose.decrementAndGet();
        this.connectionCloseTimes.record(duration, timeUnit);
    }

    @Override
    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.liveConnections.decrementAndGet();
        this.pendingConnectionClose.decrementAndGet();
        this.connectionCloseTimes.record(duration, timeUnit);
        this.failedConnectionClose.increment();
    }

    @Override
    protected void onNewClientConnected() {
        this.liveConnections.incrementAndGet();
    }

    @Override
    protected void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    @Override
    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingFlushes.decrementAndGet();
        this.failedFlushes.increment();
    }

    @Override
    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
        this.pendingFlushes.decrementAndGet();
        this.flushTimes.record(duration, timeUnit);
    }

    @Override
    protected void onFlushStart() {
        this.pendingFlushes.incrementAndGet();
    }

    @Override
    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingWrites.decrementAndGet();
        this.failedWrites.increment();
    }

    @Override
    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
        this.pendingWrites.decrementAndGet();
        this.bytesWritten.increment(bytesWritten);
        this.writeTimes.record(duration, timeUnit);
    }

    @Override
    protected void onWriteStart() {
        this.pendingWrites.incrementAndGet();
    }

    @Override
    public void onCompleted() {
    }

    @Override
    public void onSubscribe() {
    }

    public static TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>> newListener(String monitorId) {
        return new TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>>(monitorId);
    }

    public long getLiveConnections() {
        return this.liveConnections.get();
    }

    public long getInflightConnections() {
        return this.inflightConnections.get();
    }

    public long getFailedConnections() {
        return this.failedConnections.count();
    }

    public Timer getConnectionProcessingTimes() {
        return this.connectionProcessingTimes;
    }

    public long getPendingWrites() {
        return this.pendingWrites.get();
    }

    public long getPendingFlushes() {
        return this.pendingFlushes.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.count();
    }

    public Timer getWriteTimes() {
        return this.writeTimes;
    }

    public long getBytesRead() {
        return this.bytesRead.count();
    }

    public long getFailedWrites() {
        return this.failedWrites.count();
    }

    public long getFailedFlushes() {
        return this.failedFlushes.count();
    }

    public Timer getFlushTimes() {
        return this.flushTimes;
    }
}

