/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator;

import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.websocket.WebSocketClient;
import io.reactivex.netty.protocol.http.websocket.WebSocketServer;
import io.reactivex.netty.protocol.udp.client.UdpClient;
import io.reactivex.netty.protocol.udp.server.UdpServer;
import io.reactivex.netty.server.RxServer;
import io.reactivex.netty.server.ServerMetricsEvent;
import io.reactivex.netty.spectator.http.HttpClientListener;
import io.reactivex.netty.spectator.http.HttpServerListener;
import io.reactivex.netty.spectator.http.websocket.WebSocketClientListener;
import io.reactivex.netty.spectator.http.websocket.WebSocketServerListener;
import io.reactivex.netty.spectator.tcp.TcpClientListener;
import io.reactivex.netty.spectator.tcp.TcpServerListener;
import io.reactivex.netty.spectator.udp.UdpClientListener;
import io.reactivex.netty.spectator.udp.UdpServerListener;

public class SpectatorEventsListenerFactory
extends MetricEventsListenerFactory {
    private final String clientMetricNamePrefix;
    private final String serverMetricNamePrefix;

    public SpectatorEventsListenerFactory() {
        this("rxnetty-client-", "rxnetty-server-");
    }

    public SpectatorEventsListenerFactory(String clientMetricNamePrefix, String serverMetricNamePrefix) {
        this.clientMetricNamePrefix = clientMetricNamePrefix;
        this.serverMetricNamePrefix = serverMetricNamePrefix;
    }

    public TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>> forTcpClient(RxClient client) {
        return TcpClientListener.newListener(this.clientMetricNamePrefix + client.name());
    }

    public HttpClientListener forHttpClient(HttpClient client) {
        return HttpClientListener.newHttpListener(this.clientMetricNamePrefix + client.name());
    }

    public WebSocketClientListener forWebSocketClient(WebSocketClient client) {
        return WebSocketClientListener.newWebSocketListener(this.clientMetricNamePrefix + client.name());
    }

    public UdpClientListener forUdpClient(UdpClient client) {
        return UdpClientListener.newUdpListener(this.clientMetricNamePrefix + client.name());
    }

    public TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>> forTcpServer(RxServer server) {
        return TcpServerListener.newListener(this.serverMetricNamePrefix + server.getServerPort());
    }

    public HttpServerListener forHttpServer(HttpServer server) {
        return HttpServerListener.newHttpListener(this.serverMetricNamePrefix + server.getServerPort());
    }

    public WebSocketServerListener forWebSocketServer(WebSocketServer server) {
        return WebSocketServerListener.newWebSocketListener(this.serverMetricNamePrefix + server.getServerPort());
    }

    public UdpServerListener forUdpServer(UdpServer server) {
        return UdpServerListener.newUdpListener(this.serverMetricNamePrefix + server.getServerPort());
    }
}

